<?php
// Menyembunyikan semua error dan notice
error_reporting(0);

// Menghubungkan ke database
include 'session.php';
include 'navbar.php';  // Pastikan navbar di-load di bagian atas
include 'config.php';

// Mengambil data kapal dari database dan mengurutkannya berdasarkan tanggal closing (asc)
$sql = "SELECT *, DATEDIFF(closing, CURDATE()) AS days_diff FROM shipment_info ORDER BY closing ASC"; // Mengurutkan berdasarkan tanggal closing secara ascending
$result = $conn->query($sql);

// Menutup koneksi
$conn->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Kapal</title>

    <!-- Google Fonts: Inter & Open Sans -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&family=Open+Sans&display=swap" rel="stylesheet" />

    <style>
        /* Mengatur font dan dasar halaman */
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f7f7f7;
            margin: 0;
            padding: 0;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        /* Navbar Styling */
        nav {
            background-color: #333;
            padding: 15px;
            color: white;
            text-align: center;
        }

        nav a {
            color: white;
            text-decoration: none;
            margin: 0 15px;
            font-size: 1.2rem;
        }

        nav a:hover {
            text-decoration: underline;
        }

        /* Mengatur styling untuk container utama */
        .container {
            background-color: #fff;
            padding: 30px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            width: 100%;
            max-width: 800px;
            margin-top: 20px; /* Menambahkan jarak dari navbar */
            margin-left: auto;
            margin-right: auto;
        }

        /* Styling judul */
        h2 {
            font-size: 2rem;
            color: #333;
            margin-bottom: 20px;
            text-align: center;
        }

        /* Styling tabel */
        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            padding: 8px 12px;
            text-align: left;
            border: 1px solid #ddd;
        }

        th {
            background-color: #f4f4f4;
            font-weight: bold;
        }

        /* Styling untuk baris dengan H+0 hingga H+7 */
        .near-due {
            background-color: #f8d7da; /* Warna merah muda */
            color: #721c24; /* Teks merah */
        }

        /* Styling tombol kembali */
        .back-button {
            background-color: #007bff;
            color: white;
            font-size: 1rem;
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-align: center;
            display: block;
            width: 100%;
            margin-top: 20px;
        }

        .back-button:hover {
            background-color: #0056b3;
        }

        /* Menyembunyikan kolom kapal secara default */
        .kapal-column {
            display: none;
        }

        /* Styling untuk tombol delete */
        .delete-btn {
            background-color: red;
            color: white;
            font-size: 1rem;
            padding: 5px 10px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-align: center;
        }

        .delete-btn:hover {
            background-color: darkred;
        }
    </style>
</head>
<body>

    <!-- Konten utama -->
    <div class="container">
        <h2>Daftar Kapal</h2>

        <!-- Tombol untuk menampilkan kolom kapal -->
        <button onclick="toggleKapalColumn()">Tampilkan Kolom Kapal</button>

        <!-- Tabel untuk menampilkan data kapal -->
        <table>
            <thead>
                <tr>
                    <th>Tujuan</th>
                    <th class="kapal-column">Kapal</th> <!-- Menyembunyikan kolom kapal secara default -->
                    <th>Closing</th>
                    <th>Berangkat</th>
                    <th>Tiba</th>
                    <th>H+</th> <!-- Menambahkan kolom H+ -->
                    <th>Action</th> <!-- Kolom untuk tombol Delete -->
                </tr>
            </thead>
            <tbody>
                <?php
                // Jika ada data kapal, tampilkan dalam tabel
                if ($result->num_rows > 0) {
                    while($row = $result->fetch_assoc()) {
                        // Menentukan warna baris berdasarkan H+ (selisih hari lebih dari 0 dan hingga 7 hari)
                        $row_class = "";
                        // Menandai baris dengan H+ antara 0 hingga 7 hari
                        if ($row['days_diff'] >= 0 && $row['days_diff'] <= 7) {
                            $row_class = "near-due"; // Menandai baris dengan H+0 hingga H+7
                        }

                        // Mengonversi tanggal ke format dd-mm-yyyy
                        $closing_date = DateTime::createFromFormat('Y-m-d', $row['closing'])->format('d-m-Y');
                        $berangkat_date = DateTime::createFromFormat('Y-m-d', $row['berangkat'])->format('d-m-Y');
                        $tiba_date = DateTime::createFromFormat('Y-m-d', $row['tiba'])->format('d-m-Y');

                        // Menampilkan data dalam tabel dengan H+ format
                        echo "<tr class='$row_class'>
                                <td>" . htmlspecialchars($row["tujuan"]) . "</td>
                                <td class='kapal-column'>" . htmlspecialchars($row["kapal"]) . "</td>
                                <td>" . $closing_date . "</td>
                                <td>" . $berangkat_date . "</td>
                                <td>" . $tiba_date . "</td>
                                <td>H+" . abs($row["days_diff"]) . "</td> <!-- Menampilkan H+ -->
                                <td>
                                    <form action='delete_kapal.php' method='POST' onsubmit='return confirm(\"Apakah Anda yakin ingin menghapus data kapal?\")'>
                                        <input type='hidden' name='kapal_id' value='" . $row["id"] . "' />
                                        <button type='submit' class='delete-btn'>Hapus</button>
                                    </form>
                                </td>
                              </tr>";
                    }
                } else {
                    echo "<tr><td colspan='7'>Tidak ada data kapal.</td></tr>";
                }
                ?>
            </tbody>
        </table>

        <!-- Tombol Kembali -->
        <a href="index.php" class="back-button">Kembali ke Form Input</a>
    </div>

    <script>
        // Fungsi untuk toggle tampilan kolom kapal
        function toggleKapalColumn() {
            var kapalColumns = document.querySelectorAll('.kapal-column');
            kapalColumns.forEach(function(column) {
                if (column.style.display === 'none') {
                    column.style.display = 'table-cell';
                } else {
                    column.style.display = 'none';
                }
            });
        }
    </script>

</body>
</html>
