<?php
/**
 * Script Upload Nota untuk Sistem Penjualan
 * File: upload_nota.php
 */

header('Content-Type: text/plain; charset=utf-8');

// Konfigurasi upload
$upload_dir = 'nota_uploads/';
$max_file_size = 2 * 1024 * 1024; // 2MB
$allowed_extensions = ['pdf', 'jpg', 'jpeg', 'png'];

// Buat direktori jika belum ada
if (!file_exists($upload_dir)) {
    if (!mkdir($upload_dir, 0755, true)) {
        die('ERROR: Gagal membuat direktori upload');
    }
}

// Cek apakah ada file yang diupload
if (!isset($_FILES['nota']) || $_FILES['nota']['error'] !== UPLOAD_ERR_OK) {
    $error_messages = [
        UPLOAD_ERR_INI_SIZE => 'File terlalu besar (melebihi upload_max_filesize)',
        UPLOAD_ERR_FORM_SIZE => 'File terlalu besar (melebihi MAX_FILE_SIZE)',
        UPLOAD_ERR_PARTIAL => 'File hanya terupload sebagian',
        UPLOAD_ERR_NO_FILE => 'Tidak ada file yang diupload',
        UPLOAD_ERR_NO_TMP_DIR => 'Direktori temporary tidak ditemukan',
        UPLOAD_ERR_CANT_WRITE => 'Gagal menulis file ke disk',
        UPLOAD_ERR_EXTENSION => 'Upload dihentikan oleh extension'
    ];
    
    $error_code = $_FILES['nota']['error'] ?? UPLOAD_ERR_NO_FILE;
    $error_message = $error_messages[$error_code] ?? 'Error tidak diketahui';
    die("ERROR: $error_message");
}

$file = $_FILES['nota'];

// Validasi ukuran file
if ($file['size'] > $max_file_size) {
    die('ERROR: Ukuran file terlalu besar. Maksimal 2MB');
}

// Validasi tipe file
$file_info = pathinfo($file['name']);
$extension = strtolower($file_info['extension'] ?? '');

if (!in_array($extension, $allowed_extensions)) {
    die('ERROR: Tipe file tidak diizinkan. Hanya: ' . implode(', ', $allowed_extensions));
}

// Validasi MIME type untuk keamanan ekstra
$allowed_mime_types = [
    'pdf' => 'application/pdf',
    'jpg' => 'image/jpeg',
    'jpeg' => 'image/jpeg',
    'png' => 'image/png'
];

$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mime_type = finfo_file($finfo, $file['tmp_name']);
finfo_close($finfo);

if (!isset($allowed_mime_types[$extension]) || $mime_type !== $allowed_mime_types[$extension]) {
    die('ERROR: Tipe file tidak sesuai dengan ekstensi');
}

// Generate nama file unik
$timestamp = date('YmdHis');
$random = substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyz'), 0, 6);
$safe_original_name = preg_replace('/[^a-zA-Z0-9_-]/', '', $file_info['filename']);
$safe_original_name = substr($safe_original_name, 0, 20); // Batasi panjang nama

$new_filename = "nota_{$timestamp}_{$random}_{$safe_original_name}.{$extension}";
$destination = $upload_dir . $new_filename;

// Pindahkan file
if (!move_uploaded_file($file['tmp_name'], $destination)) {
    die('ERROR: Gagal memindahkan file ke direktori tujuan');
}

// Set permission yang tepat
chmod($destination, 0644);

// Log upload (opsional - untuk audit trail)
$log_entry = date('Y-m-d H:i:s') . " - Upload: {$new_filename} (Size: {$file['size']} bytes, IP: {$_SERVER['REMOTE_ADDR']})\n";
file_put_contents($upload_dir . 'upload.log', $log_entry, FILE_APPEND | LOCK_EX);

// Return nama file yang berhasil diupload
echo $new_filename;
?>