<?php
include 'config.php';

// Ambil semua data customer dan urutkan berdasarkan kota dan id
$result = mysqli_query($conn, "SELECT id, kota FROM customer ORDER BY kota ASC, id ASC");

if (!$result) {
    die("Gagal mengambil data: " . mysqli_error($conn));
}

$kode_map = []; // prefix kota => nomor urut
$updates = [];

while ($row = mysqli_fetch_assoc($result)) {
    $id = $row['id'];
    $kota = strtoupper(substr(preg_replace('/\s+/', '', $row['kota']), 0, 3)); // 3 huruf kota tanpa spasi

    if (strlen($kota) < 3) {
        $kota = str_pad($kota, 3, 'X'); // fallback jika kota kosong atau terlalu pendek
    }

    if (!isset($kode_map[$kota])) {
        $kode_map[$kota] = 1;
    } else {
        $kode_map[$kota]++;
    }

    $urutan = str_pad($kode_map[$kota], 3, '0', STR_PAD_LEFT);
    $kode_baru = $kota . $urutan;

    $query = "UPDATE customer SET kode = '$kode_baru' WHERE id = $id";
    if (!mysqli_query($conn, $query)) {
        echo "Gagal update ID $id: " . mysqli_error($conn) . "<br>";
    } else {
        echo "Update ID $id => $kode_baru<br>";
    }
}

echo "<br><strong>Update selesai.</strong>";
?>
