<?php
include 'config.php';

if (!isset($_GET['q']) || empty($_GET['q'])) {
    echo json_encode([]);
    exit;
}

$query = mysqli_real_escape_string($conn, $_GET['q']);

// Advanced fuzzy search algorithm
function calculateSimilarity($str1, $str2) {
    $str1 = strtolower($str1);
    $str2 = strtolower($query);
    
    // Exact match gets highest priority
    if ($str1 === $str2) return 100;
    
    // Contains match
    if (strpos($str1, $str2) !== false) return 90 + (strlen($str2) / strlen($str1)) * 10;
    
    // Word start match
    $words1 = explode(' ', $str1);
    $words2 = explode(' ', $str2);
    $wordMatches = 0;
    
    foreach ($words2 as $word2) {
        foreach ($words1 as $word1) {
            if (strpos($word1, $word2) === 0) {
                $wordMatches++;
                break;
            }
        }
    }
    
    if ($wordMatches > 0) {
        return 70 + ($wordMatches / count($words2)) * 20;
    }
    
    // Levenshtein distance for typo tolerance
    $maxLen = max(strlen($str1), strlen($str2));
    if ($maxLen > 0) {
        $distance = levenshtein($str1, $str2);
        $similarity = (1 - $distance / $maxLen) * 100;
        return max(0, $similarity);
    }
    
    return 0;
}

// Get all products
$sql = "SELECT nama FROM produk_interest ORDER BY nama ASC";
$result = mysqli_query($conn, $sql);

$products = [];
while ($row = mysqli_fetch_assoc($result)) {
    $similarity = calculateSimilarity($row['nama'], $query);
    if ($similarity > 30) { // Only show results with >30% similarity
        $products[] = [
            'nama' => $row['nama'],
            'similarity' => $similarity
        ];
    }
}

// Sort by similarity (highest first)
usort($products, function($a, $b) {
    return $b['similarity'] <=> $a['similarity'];
});

// Return top 10 results
$results = array_slice($products, 0, 10);

// Remove similarity score from output
$output = array_map(function($item) {
    return ['nama' => $item['nama']];
}, $results);

header('Content-Type: application/json');
echo json_encode($output);