<?php
include 'config.php';
include 'session.php';
include 'navbar.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$data = array(
    'nama_rekening' => '',
    'nama_bank' => '',
    'nomor_rekening' => '',
    'nama_pemilik' => '',
    'aktif' => 1
);

if ($id) {
    $query = mysqli_query($conn, "SELECT * FROM rekening WHERE id = '$id'");
    if ($query && $row = mysqli_fetch_assoc($query)) {
        $data = $row;
    } else {
        echo "<script>alert('Data tidak ditemukan!'); window.location='rekening_list.php';</script>";
        exit;
    }
}

// Daftar bank populer di Indonesia
$bank_list = array(
    'BCA', 'BRI', 'BNI', 'MANDIRI', 'CIMB NIAGA', 'DANAMON', 'PERMATA', 
    'MAYBANK', 'OCBC NISP', 'PANIN', 'BTN', 'MEGA', 'BUKOPIN', 
    'BSI', 'MUAMALAT', 'JENIUS', 'DIGIBANK', 'TMRW', 'SEABANK'
);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $id ? 'Edit' : 'Tambah'; ?> Rekening - SBA System</title>
    
    <style>
        body {
            font-family: 'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f8f9fa;
            color: #333;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }

        .card {
            background: white;
            border-radius: 12px;
            border: 1px solid #ddd;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .card-header {
            background: #f8f9fa;
            border-bottom: 1px solid #ddd;
            padding: 20px;
            border-radius: 12px 12px 0 0;
        }

        .card-body {
            padding: 20px;
        }

        h3 {
            color: #333;
            font-weight: 600;
            margin: 0;
        }

        .form-label {
            font-weight: 500;
            color: #333;
            margin-bottom: 6px;
            display: block;
        }

        .form-control, .form-select {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 12px 16px;
            font-size: 14px;
            transition: all 0.2s;
            width: 100%;
            box-sizing: border-box;
        }

        .form-control:focus, .form-select:focus {
            border-color: #007bff;
            box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.1);
            outline: none;
        }

        .btn {
            border-radius: 8px;
            padding: 12px 24px;
            font-size: 14px;
            font-weight: 500;
            border: none;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            display: inline-block;
        }

        .btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
            text-decoration: none;
        }

        .btn-success {
            background: #28a745;
            color: white;
        }

        .btn-success:hover {
            background: #218838;
            color: white;
        }

        .btn-secondary {
            background: #6c757d;
            color: white;
        }

        .btn-secondary:hover {
            background: #545b62;
            color: white;
        }

        .mb-3 {
            margin-bottom: 1rem;
        }

        .mt-4 {
            margin-top: 1.5rem;
        }

        .d-flex {
            display: flex;
        }

        .gap-2 {
            gap: 0.5rem;
        }

        .text-muted {
            color: #6c757d !important;
            font-size: 13px;
        }

        .text-danger {
            color: #dc3545 !important;
        }

        .form-check {
            margin-top: 10px;
        }

        .form-check-input {
            margin-top: 0.125rem;
            margin-right: 8px;
        }

        .form-check-label {
            font-weight: 400;
        }

        .alert {
            padding: 12px 16px;
            margin-bottom: 16px;
            border-radius: 4px;
        }

        .alert-info {
            background-color: #d1ecf1;
            border-color: #bee5eb;
            color: #0c5460;
        }

        @media (max-width: 768px) {
            .container {
                padding: 10px;
            }
            
            .card-header, .card-body {
                padding: 15px;
            }
            
            .btn {
                width: 100%;
                margin-bottom: 10px;
            }
            
            .d-flex {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>

<div class="container mt-4">
    <div class="card">
        <div class="card-header">
            <h3><?php echo $id ? 'Edit' : 'Tambah'; ?> Rekening</h3>
        </div>
        <div class="card-body">
            <form action="rekening_simpan.php" method="post" id="form-rekening">
                <input type="hidden" name="id" value="<?php echo $id; ?>">

                <div class="mb-3">
                    <label class="form-label">Nama Rekening <span class="text-danger">*</span></label>
                    <input type="text" name="nama_rekening" class="form-control" required 
                           value="<?php echo htmlspecialchars($data['nama_rekening']); ?>"
                           placeholder="Contoh: AHMAD ANDIK NURFIANSYAH">
                    <div class="text-muted">Nama yang akan ditampilkan di form transaksi</div>
                </div>

                <div class="mb-3">
                    <label class="form-label">Bank <span class="text-danger">*</span></label>
                    <select name="nama_bank" class="form-select" required>
                        <option value="">-- Pilih Bank --</option>
                        <?php foreach ($bank_list as $bank): ?>
                        <option value="<?php echo $bank; ?>" 
                                <?php echo ($data['nama_bank'] == $bank) ? 'selected' : ''; ?>>
                            <?php echo $bank; ?>
                        </option>
                        <?php endforeach; ?>
                        <option value="LAINNYA" <?php echo ($data['nama_bank'] == 'LAINNYA') ? 'selected' : ''; ?>>LAINNYA</option>
                    </select>
                </div>

                <!-- Input manual untuk bank lain -->
                <div class="mb-3" id="bank-lainnya" style="display: none;">
                    <label class="form-label">Nama Bank Lainnya</label>
                    <input type="text" id="nama_bank_manual" class="form-control" 
                           placeholder="Masukkan nama bank">
                </div>

                <div class="mb-3">
                    <label class="form-label">Nomor Rekening <span class="text-danger">*</span></label>
                    <input type="text" name="nomor_rekening" class="form-control" required 
                           value="<?php echo htmlspecialchars($data['nomor_rekening']); ?>"
                           placeholder="Contoh: 1900332013"
                           pattern="[0-9]+"
                           title="Hanya boleh angka">
                    <div class="text-muted">Hanya masukkan angka tanpa spasi atau tanda baca</div>
                </div>

                <div class="mb-3">
                    <label class="form-label">Nama Pemilik Rekening <span class="text-danger">*</span></label>
                    <input type="text" name="nama_pemilik" class="form-control" required 
                           value="<?php echo htmlspecialchars($data['nama_pemilik']); ?>"
                           placeholder="Contoh: HARTONO MULTI REJEKI"
                           style="text-transform: uppercase;">
                    <div class="text-muted">Nama pemilik sesuai dengan data bank (akan otomatis huruf besar)</div>
                </div>

                <div class="mb-3">
                    <div class="form-check">
                        <input type="checkbox" name="aktif" id="aktif" class="form-check-input" 
                               value="1" <?php echo ($data['aktif'] == 1) ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="aktif">
                            Rekening aktif (bisa digunakan untuk transaksi)
                        </label>
                    </div>
                </div>

                <div class="d-flex gap-2 mt-4">
                    <button type="submit" class="btn btn-success" id="btn-submit">
                        <?php echo $id ? 'Update' : 'Simpan'; ?> Rekening
                    </button>
                    <a href="rekening_list.php" class="btn btn-secondary">Kembali</a>
                </div>
            </form>
        </div>
    </div>
    
    <?php if (!$id): ?>
    <div class="mt-4">
        <div class="alert alert-info">
            <strong>Tips:</strong>
            <ul class="mb-0 mt-2">
                <li>Pastikan nomor rekening benar sesuai dengan data bank</li>
                <li>Nama pemilik harus sama persis dengan nama di bank</li>
                <li>Hanya rekening aktif yang akan muncul di form transaksi</li>
                <li>Rekening yang sudah digunakan di transaksi tidak dapat dihapus</li>
            </ul>
        </div>
    </div>
    <?php endif; ?>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const bankSelect = document.querySelector('select[name="nama_bank"]');
    const bankLainnya = document.getElementById('bank-lainnya');
    const namaBankManual = document.getElementById('nama_bank_manual');
    const namaPemilikInput = document.querySelector('input[name="nama_pemilik"]');
    const nomorRekeningInput = document.querySelector('input[name="nomor_rekening"]');
    const form = document.getElementById('form-rekening');
    
    // Handle bank selection
    bankSelect.addEventListener('change', function() {
        if (this.value === 'LAINNYA') {
            bankLainnya.style.display = 'block';
            namaBankManual.required = true;
        } else {
            bankLainnya.style.display = 'none';
            namaBankManual.required = false;
            namaBankManual.value = '';
        }
    });
    
    // Trigger change event on load
    bankSelect.dispatchEvent(new Event('change'));
    
    // Auto uppercase untuk nama pemilik
    namaPemilikInput.addEventListener('input', function() {
        this.value = this.value.toUpperCase();
    });

    // Validasi nomor rekening (hanya angka)
    nomorRekeningInput.addEventListener('input', function() {
        this.value = this.value.replace(/[^0-9]/g, '');
    });

    // Validasi form
    form.addEventListener('submit', function(e) {
        const namaRekening = document.querySelector('input[name="nama_rekening"]').value.trim();
        const namaBank = bankSelect.value;
        const nomorRekening = nomorRekeningInput.value.trim();
        const namaPemilik = namaPemilikInput.value.trim();

        if (!namaRekening) {
            e.preventDefault();
            alert('Nama rekening harus diisi!');
            document.querySelector('input[name="nama_rekening"]').focus();
            return false;
        }

        if (!namaBank) {
            e.preventDefault();
            alert('Bank harus dipilih!');
            bankSelect.focus();
            return false;
        }

        if (namaBank === 'LAINNYA' && !namaBankManual.value.trim()) {
            e.preventDefault();
            alert('Nama bank lainnya harus diisi!');
            namaBankManual.focus();
            return false;
        }

        if (!nomorRekening) {
            e.preventDefault();
            alert('Nomor rekening harus diisi!');
            nomorRekeningInput.focus();
            return false;
        }

        if (nomorRekening.length < 8) {
            e.preventDefault();
            alert('Nomor rekening minimal 8 digit!');
            nomorRekeningInput.focus();
            return false;
        }

        if (!namaPemilik) {
            e.preventDefault();
            alert('Nama pemilik harus diisi!');
            namaPemilikInput.focus();
            return false;
        }

        // Update nama bank jika pilih lainnya
        if (namaBank === 'LAINNYA') {
            bankSelect.value = namaBankManual.value.toUpperCase();
        }

        // Show loading
        const submitBtn = document.getElementById('btn-submit');
        const originalText = submitBtn.innerHTML;
        submitBtn.innerHTML = 'Menyimpan...';
        submitBtn.disabled = true;

        // Reset after 10 seconds if failed
        setTimeout(function() {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        }, 10000);
    });
});
</script>

</body>
</html>