<?php
include 'config.php';

$sql = "
    SELECT 
        p.id, 
        p.tanggal, 
        c.nama AS relasi,
        s.nama AS supplier,
        SUM(d.qty * d.harga) AS total_jual,
        SUM(d.qty * d.harga_beli) AS total_beli,
        (SUM(d.qty * d.harga) - SUM(d.qty * d.harga_beli)) AS profit
    FROM penjualan p
    JOIN penjualan_detail d ON p.id = d.penjualan_id
    LEFT JOIN customer c ON p.customer_id = c.id
    LEFT JOIN supplier s ON d.supplier = s.id
    GROUP BY p.id, p.tanggal, c.nama, s.nama
    ORDER BY p.tanggal DESC
";

$result = $conn->query($sql);

$total_jual_all = 0;
$total_beli_all = 0;
$total_profit_all = 0;

echo '<table class="table table-bordered table-sm">';
echo '<thead><tr>
        <th>ID</th>
        <th>Tanggal</th>
        <th>Relasi</th>
        <th>Supplier</th>
        <th>Total Jual</th>
        <th>Total Beli</th>
        <th>Profit</th>
      </tr></thead><tbody>';

while($row = $result->fetch_assoc()) {
    $total_jual_all += $row['total_jual'];
    $total_beli_all += $row['total_beli'];
    $total_profit_all += $row['profit'];

    echo '<tr>
            <td>'.$row['id'].'</td>
            <td>'.$row['tanggal'].'</td>
            <td>'.$row['relasi'].'</td>
            <td>'.$row['supplier'].'</td>
            <td>Rp '.number_format($row['total_jual'], 0, ',', '.').'</td>
            <td>Rp '.number_format($row['total_beli'], 0, ',', '.').'</td>
            <td class="fw-bold text-success">Rp '.number_format($row['profit'], 0, ',', '.').'</td>
          </tr>';
}

echo '<tr class="fw-bold table-light">
        <td colspan="4" class="text-end">TOTAL</td>
        <td>Rp '.number_format($total_jual_all, 0, ',', '.').'</td>
        <td>Rp '.number_format($total_beli_all, 0, ',', '.').'</td>
        <td class="text-success">Rp '.number_format($total_profit_all, 0, ',', '.').'</td>
      </tr>';

echo '</tbody></table>';
?>
