<?php
include 'config.php';
include 'session.php';

// Ambil data dari form
$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$no_invoice = mysqli_real_escape_string($conn, $_POST['no_invoice']);
$tanggal = mysqli_real_escape_string($conn, $_POST['tanggal']);
$jenis = mysqli_real_escape_string($conn, $_POST['jenis']);
$customer_id = (int)$_POST['customer_id'];

// Cek apakah menggunakan rekening_id (master rekening) atau rekening lama
$rekening_id = null;
$rekening = '';

if (isset($_POST['rekening_id']) && !empty($_POST['rekening_id'])) {
    // Menggunakan master rekening
    $rekening_id = (int)$_POST['rekening_id'];
    
    // Ambil nama rekening untuk fallback ke kolom lama jika perlu
    $rek_query = mysqli_query($conn, "SELECT nama_rekening FROM rekening WHERE id = $rekening_id");
    if ($rek_query && $rek_data = mysqli_fetch_assoc($rek_query)) {
        $rekening = mysqli_real_escape_string($conn, $rek_data['nama_rekening']);
    }
} elseif (isset($_POST['rekening']) && !empty($_POST['rekening'])) {
    // Fallback ke rekening lama
    $rekening = mysqli_real_escape_string($conn, $_POST['rekening']);
}

// Validasi rekening
if (empty($rekening_id) && empty($rekening)) {
    echo "<script>alert('Rekening harus dipilih!'); history.back();</script>";
    exit;
}

// Data status pembayaran - pastikan ada default value
$status_bayar = isset($_POST['status_bayar']) ? mysqli_real_escape_string($conn, $_POST['status_bayar']) : 'belum_bayar';
$tanggal_bayar = null;
$keterangan_bayar = '';

// Proses tanggal bayar dan keterangan
if (isset($_POST['tanggal_bayar']) && !empty($_POST['tanggal_bayar'])) {
    $tanggal_bayar = mysqli_real_escape_string($conn, $_POST['tanggal_bayar']);
}

if (isset($_POST['keterangan_bayar'])) {
    $keterangan_bayar = mysqli_real_escape_string($conn, $_POST['keterangan_bayar']);
}

// Validasi: jika status lunas, tanggal bayar harus diisi
if ($status_bayar == 'lunas' && empty($tanggal_bayar)) {
    echo "<script>alert('Tanggal bayar harus diisi jika status LUNAS!'); history.back();</script>";
    exit;
}

// Jika status belum_bayar, kosongkan tanggal bayar dan keterangan
if ($status_bayar == 'belum_bayar') {
    $tanggal_bayar = null;
    $keterangan_bayar = '';
}

// Data produk
$produk_ids = $_POST['produk_id'];
$jumlahs = $_POST['jumlah'];
$units = $_POST['unit'];
$harga_juals = $_POST['harga_jual'];
$suppliers = isset($_POST['supplier']) ? $_POST['supplier'] : array();
$harga_belis = isset($_POST['harga_beli']) ? $_POST['harga_beli'] : array();
$nota_namas = isset($_POST['nota_nama']) ? $_POST['nota_nama'] : array();

// Validasi data produk
$valid_products = array();
for ($i = 0; $i < count($produk_ids); $i++) {
    if (!empty($produk_ids[$i]) && !empty($jumlahs[$i]) && !empty($harga_juals[$i])) {
        $valid_products[] = array(
            'produk_id' => (int)$produk_ids[$i],
            'qty' => (float)$jumlahs[$i],
            'satuan' => mysqli_real_escape_string($conn, $units[$i]),
            'harga' => (float)$harga_juals[$i],
            'supplier' => isset($suppliers[$i]) ? mysqli_real_escape_string($conn, $suppliers[$i]) : '',
            'harga_beli' => isset($harga_belis[$i]) ? (float)$harga_belis[$i] : 0,
            'nota' => isset($nota_namas[$i]) ? mysqli_real_escape_string($conn, $nota_namas[$i]) : ''
        );
    }
}

if (empty($valid_products)) {
    echo "<script>alert('Minimal harus ada 1 produk yang valid!'); history.back();</script>";
    exit;
}

// Cek apakah kolom rekening_id sudah ada di tabel penjualan
$check_column = mysqli_query($conn, "SHOW COLUMNS FROM penjualan LIKE 'rekening_id'");
$has_rekening_id = mysqli_num_rows($check_column) > 0;

// Mulai transaksi
mysqli_begin_transaction($conn);

try {
    if ($id > 0) {
        // UPDATE data yang sudah ada
        
        // Cek apakah transaksi sudah lunas sebelumnya
        $check_query = "SELECT status_bayar FROM penjualan WHERE id = $id";
        $check_result = mysqli_query($conn, $check_query);
        if ($check_result) {
            $check_data = mysqli_fetch_assoc($check_result);
            if ($check_data['status_bayar'] == 'lunas' && $status_bayar != 'lunas') {
                throw new Exception('Transaksi yang sudah LUNAS tidak dapat diubah statusnya!');
            }
        }
        
        // Prepare tanggal bayar untuk query
        $tanggal_bayar_sql = $tanggal_bayar ? "'$tanggal_bayar'" : 'NULL';
        
        // Build update query berdasarkan struktur database
        if ($has_rekening_id && $rekening_id) {
            // Update menggunakan rekening_id
            $update_query = "UPDATE penjualan SET 
                            no_invoice = '$no_invoice',
                            tanggal = '$tanggal',
                            jenis = '$jenis',
                            customer_id = $customer_id,
                            rekening_id = $rekening_id,
                            status_bayar = '$status_bayar',
                            tanggal_bayar = $tanggal_bayar_sql,
                            keterangan_bayar = '$keterangan_bayar'
                            WHERE id = $id";
        } else {
            // Update menggunakan rekening lama
            $update_query = "UPDATE penjualan SET 
                            no_invoice = '$no_invoice',
                            tanggal = '$tanggal',
                            jenis = '$jenis',
                            customer_id = $customer_id,
                            rekening = '$rekening',
                            status_bayar = '$status_bayar',
                            tanggal_bayar = $tanggal_bayar_sql,
                            keterangan_bayar = '$keterangan_bayar'
                            WHERE id = $id";
        }
        
        if (!mysqli_query($conn, $update_query)) {
            throw new Exception('Gagal update header penjualan: ' . mysqli_error($conn));
        }
        
        // Hapus detail lama
        $delete_detail = "DELETE FROM penjualan_detail WHERE penjualan_id = $id";
        if (!mysqli_query($conn, $delete_detail)) {
            throw new Exception('Gagal menghapus detail lama: ' . mysqli_error($conn));
        }
        
        // Insert detail baru
        foreach ($valid_products as $product) {
            $insert_detail = "INSERT INTO penjualan_detail 
                            (penjualan_id, produk_id, qty, satuan, harga, supplier, harga_beli, nota) 
                            VALUES 
                            ($id, {$product['produk_id']}, {$product['qty']}, 
                             '{$product['satuan']}', {$product['harga']}, 
                             '{$product['supplier']}', {$product['harga_beli']}, 
                             '{$product['nota']}')";
            
            if (!mysqli_query($conn, $insert_detail)) {
                throw new Exception('Gagal insert detail produk: ' . mysqli_error($conn));
            }
        }
        
        mysqli_commit($conn);
        echo "<script>alert('Data penjualan berhasil diupdate!'); window.location.href='penjualan_form.php?id=$id';</script>";
        
    } else {
        // INSERT data baru
        
        // Prepare tanggal bayar untuk query (untuk insert baru, status selalu belum_bayar)
        $status_bayar = 'belum_bayar';
        $tanggal_bayar_sql = 'NULL';
        $keterangan_bayar = '';
        
        // Build insert query berdasarkan struktur database
        if ($has_rekening_id && $rekening_id) {
            // Insert menggunakan rekening_id
            $insert_query = "INSERT INTO penjualan 
                            (no_invoice, tanggal, jenis, customer_id, rekening_id, status_bayar, tanggal_bayar, keterangan_bayar) 
                            VALUES 
                            ('$no_invoice', '$tanggal', '$jenis', $customer_id, $rekening_id, '$status_bayar', $tanggal_bayar_sql, '$keterangan_bayar')";
        } else {
            // Insert menggunakan rekening lama
            $insert_query = "INSERT INTO penjualan 
                            (no_invoice, tanggal, jenis, customer_id, rekening, status_bayar, tanggal_bayar, keterangan_bayar) 
                            VALUES 
                            ('$no_invoice', '$tanggal', '$jenis', $customer_id, '$rekening', '$status_bayar', $tanggal_bayar_sql, '$keterangan_bayar')";
        }
        
        if (!mysqli_query($conn, $insert_query)) {
            throw new Exception('Gagal insert header penjualan: ' . mysqli_error($conn));
        }
        
        $new_id = mysqli_insert_id($conn);
        
        // Insert detail
        foreach ($valid_products as $product) {
            $insert_detail = "INSERT INTO penjualan_detail 
                            (penjualan_id, produk_id, qty, satuan, harga, supplier, harga_beli, nota) 
                            VALUES 
                            ($new_id, {$product['produk_id']}, {$product['qty']}, 
                             '{$product['satuan']}', {$product['harga']}, 
                             '{$product['supplier']}', {$product['harga_beli']}, 
                             '{$product['nota']}')";
            
            if (!mysqli_query($conn, $insert_detail)) {
                throw new Exception('Gagal insert detail produk: ' . mysqli_error($conn));
            }
        }
        
        mysqli_commit($conn);
        echo "<script>alert('Data penjualan berhasil disimpan!'); window.location.href='penjualan_form.php?id=$new_id';</script>";
    }
    
} catch (Exception $e) {
    mysqli_rollback($conn);
    echo "<script>alert('Error: " . addslashes($e->getMessage()) . "'); history.back();</script>";
    exit;
}
?>