
<?php
include 'config.php';
include 'session.php';
include 'navbar.php';
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Penjualan - SBA System</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f8f9fa;
            color: #333;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        h3 {
            color: #333;
            font-weight: 600;
            margin-bottom: 20px;
        }

        .btn {
            border-radius: 4px;
            padding: 8px 16px;
            font-size: 14px;
            font-weight: 500;
            border: none;
            cursor: pointer;
            text-decoration: none;
        }

        .btn-success {
            background: #28a745;
            color: white;
        }

        .btn-success:hover {
            background: #218838;
            color: white;
        }

        .btn-primary {
            background: #007bff;
            color: white;
        }

        .btn-primary:hover {
            background: #0056b3;
            color: white;
        }

        .btn-warning {
            background: #ffc107;
            color: #212529;
        }

        .btn-warning:hover {
            background: #e0a800;
            color: #212529;
        }

        .btn-danger {
            background: #dc3545;
            color: white;
        }

        .btn-danger:hover {
            background: #c82333;
            color: white;
        }

        .btn-sm {
            padding: 4px 8px;
            font-size: 12px;
        }

        .card {
            background: white;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }

        .card-header {
            background: #f8f9fa;
            border-bottom: 1px solid #ddd;
            padding: 16px 20px;
            border-radius: 8px 8px 0 0;
        }

        .card-body {
            padding: 0;
        }

        .table {
            background: white;
            margin-bottom: 0;
            border: none;
        }

        .table thead th {
            background: #f8f9fa;
            color: #333;
            border: none;
            border-bottom: 1px solid #ddd;
            padding: 12px 16px;
            font-weight: 600;
            font-size: 14px;
        }

        .table tbody td {
            padding: 12px 16px;
            border: none;
            border-bottom: 1px solid #eee;
            vertical-align: middle;
            font-size: 14px;
        }

        .table tbody tr:hover {
            background: #f8f9fa;
        }

        .table tbody tr:last-child td {
            border-bottom: none;
        }

        .badge {
            padding: 4px 8px;
            font-size: 12px;
            border-radius: 4px;
            font-weight: 500;
        }

        .badge-ppn {
            background: #d4edda;
            color: #155724;
        }

        .badge-non-ppn {
            background: #fff3cd;
            color: #856404;
        }

        .text-end {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .mb-3 {
            margin-bottom: 1rem;
        }

        .mb-4 {
            margin-bottom: 1.5rem;
        }

        .mt-4 {
            margin-top: 1.5rem;
        }

        .d-flex {
            display: flex;
        }

        .justify-content-between {
            justify-content: space-between;
        }

        .align-items-center {
            align-items: center;
        }

        .gap-2 {
            gap: 0.5rem;
        }

        .search-box {
            max-width: 300px;
        }

        .stats-card {
            background: white;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }

        .stats-number {
            font-size: 24px;
            font-weight: 700;
            color: #007bff;
            margin-bottom: 4px;
        }

        .stats-label {
            font-size: 12px;
            color: #666;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: #666;
        }

        .empty-state img {
            width: 80px;
            opacity: 0.5;
            margin-bottom: 16px;
        }

        @media (max-width: 768px) {
            .container {
                padding: 10px;
            }
            
            .table-responsive {
                font-size: 12px;
            }
            
            .btn {
                padding: 6px 12px;
                font-size: 12px;
            }
            
            .stats-grid {
                display: grid;
                grid-template-columns: 1fr 1fr;
                gap: 10px;
                margin-bottom: 20px;
            }
        }

        @media (min-width: 769px) {
            .stats-grid {
                display: grid;
                grid-template-columns: repeat(4, 1fr);
                gap: 20px;
                margin-bottom: 30px;
            }
        }
    </style>
</head>
<body>

<div class="container mt-4">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3>Daftar Penjualan</h3>
        <a href="penjualan_form.php" class="btn btn-success" target="_self">+ Tambah Penjualan</a>
    </div>

    <?php
    // Query untuk statistik
    $stats_query = "
        SELECT 
            COUNT(*) as total_transaksi,
            SUM(CASE WHEN jenis = 'PPN' THEN 1 ELSE 0 END) as total_ppn,
            SUM(CASE WHEN jenis = 'non PPN' THEN 1 ELSE 0 END) as total_non_ppn,
            SUM(CASE WHEN status_bayar = 'lunas' THEN 1 ELSE 0 END) as total_lunas,
            SUM((SELECT SUM(qty * harga) FROM penjualan_detail WHERE penjualan_id = p.id)) as total_omzet
        FROM penjualan p
    ";
    $stats_result = mysqli_query($conn, $stats_query);
    $stats = mysqli_fetch_assoc($stats_result);
    
    // Pastikan nilai tidak null
    $total_transaksi = $stats['total_transaksi'] ?? 0;
    $total_ppn = $stats['total_ppn'] ?? 0;
    $total_non_ppn = $stats['total_non_ppn'] ?? 0;
    $total_lunas = $stats['total_lunas'] ?? 0;
    $total_omzet = $stats['total_omzet'] ?? 0;
    ?>

    <!-- Statistik Cards -->
    <div class="stats-grid">
        <div class="stats-card">
            <div class="stats-number"><?php echo number_format($total_transaksi); ?></div>
            <div class="stats-label">Total Transaksi</div>
        </div>
        <div class="stats-card">
            <div class="stats-number"><?php echo number_format($total_lunas); ?></div>
            <div class="stats-label">Sudah Lunas</div>
        </div>
        <div class="stats-card">
            <div class="stats-number"><?php echo number_format($total_transaksi - $total_lunas); ?></div>
            <div class="stats-label">Belum Bayar</div>
        </div>
        <div class="stats-card">
            <div class="stats-number">Rp <?php echo number_format($total_omzet, 0, ',', '.'); ?></div>
            <div class="stats-label">Total Omzet</div>
        </div>
    </div>

    <!-- Search & Filter -->
    <div class="card mb-4">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <strong>Data Penjualan</strong>
                <div class="d-flex gap-2">
                    <input type="text" id="searchInput" class="form-control search-box" placeholder="Cari invoice, customer...">
                    <select id="filterJenis" class="form-select" style="max-width: 150px;">
                        <option value="">Semua Jenis</option>
                        <option value="PPN">PPN</option>
                        <option value="non PPN">Non PPN</option>
                    </select>
                    <select id="filterStatus" class="form-select" style="max-width: 150px;">
                        <option value="">Semua Status</option>
                        <option value="lunas">Lunas</option>
                        <option value="belum_bayar">Belum Bayar</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table" id="penjualanTable">
                    <thead>
                        <tr>
                            <th>No. Invoice</th>
                            <th>Tanggal</th>
                            <th>Customer</th>
                            <th>Jenis</th>
                            <th>Status Bayar</th>
                            <th class="text-end">Grand Total</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                    $query = "
                        SELECT 
                            p.id, 
                            p.no_invoice, 
                            p.tanggal, 
                            p.jenis, 
                            p.status_bayar,
                            p.tanggal_bayar,
                            c.nama AS customer_nama,
                            (
                                SELECT SUM(qty * harga) 
                                FROM penjualan_detail 
                                WHERE penjualan_id = p.id
                            ) AS grand_total
                        FROM penjualan p
                        JOIN customer c ON p.customer_id = c.id
                        ORDER BY p.tanggal DESC, p.id DESC
                    ";
                    $res = mysqli_query($conn, $query);
                    
                    if ($res && mysqli_num_rows($res) > 0) {
                        while ($row = mysqli_fetch_assoc($res)) {
                            $badge_class = $row['jenis'] == 'PPN' ? 'badge-ppn' : 'badge-non-ppn';
                            $status_badge_class = $row['status_bayar'] == 'lunas' ? 'badge bg-success' : 'badge bg-warning text-dark';
                            $status_text = $row['status_bayar'] == 'lunas' ? 'LUNAS' : 'BELUM BAYAR';
                            $grand_total = $row['grand_total'] ?? 0;
                            
                            echo "<tr>";
                            echo "<td><strong>" . htmlspecialchars($row['no_invoice']) . "</strong></td>";
                            echo "<td>" . date('d/m/Y', strtotime($row['tanggal'])) . "</td>";
                            echo "<td>" . htmlspecialchars($row['customer_nama']) . "</td>";
                            echo "<td><span class='badge $badge_class'>" . htmlspecialchars($row['jenis']) . "</span></td>";
                            echo "<td><span class='$status_badge_class'>$status_text</span>";
                            if ($row['status_bayar'] == 'lunas' && !empty($row['tanggal_bayar'])) {
                                echo "<br><small class='text-muted'>" . date('d/m/Y', strtotime($row['tanggal_bayar'])) . "</small>";
                            }
                            echo "</td>";
                            echo "<td class='text-end'><strong>Rp " . number_format($grand_total, 0, ',', '.') . "</strong></td>";
                            echo "<td class='text-center'>";
                            echo "<div class='d-flex gap-2 justify-content-center'>";
                            echo "<a href='penjualan_form.php?id=" . $row['id'] . "' class='btn btn-sm btn-primary' title='Edit'>Edit</a>";
                            echo "<a href='penjualan_cetak.php?id=" . $row['id'] . "' target='_blank' class='btn btn-sm btn-warning' title='Cetak'>Cetak</a>";
                            if ($row['status_bayar'] != 'lunas') {
                                echo "<button onclick=\"hapusData(" . $row['id'] . ", '" . htmlspecialchars($row['no_invoice']) . "')\" class='btn btn-sm btn-danger' title='Hapus'>Hapus</button>";
                            }
                            echo "</div>";
                            echo "</td>";
                            echo "</tr>";
                        }
                    } else {
                        echo "<tr>";
                        echo "<td colspan='7' class='empty-state'>";
                        echo "<div>📄</div>";
                        echo "<h5>Belum ada data penjualan</h5>";
                        echo "<p>Mulai buat transaksi penjualan pertama Anda</p>";
                        echo "<a href='penjualan_form.php' class='btn btn-success'>+ Tambah Penjualan</a>";
                        echo "</td>";
                        echo "</tr>";
                    }
                    ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Info -->
    <div class="text-center mt-4">
        <small class="text-muted">
            Total <?php echo mysqli_num_rows($res ?? mysqli_query($conn, "SELECT id FROM penjualan")); ?> transaksi penjualan
        </small>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Search functionality
document.getElementById('searchInput').addEventListener('keyup', function() {
    filterTable();
});

document.getElementById('filterJenis').addEventListener('change', function() {
    filterTable();
});

document.getElementById('filterStatus').addEventListener('change', function() {
    filterTable();
});

function filterTable() {
    var searchValue = document.getElementById('searchInput').value.toLowerCase();
    var filterJenis = document.getElementById('filterJenis').value.toLowerCase();
    var filterStatus = document.getElementById('filterStatus').value.toLowerCase();
    var table = document.getElementById('penjualanTable');
    var tbody = table.getElementsByTagName('tbody')[0];
    var rows = tbody.getElementsByTagName('tr');

    for (var i = 0; i < rows.length; i++) {
        var row = rows[i];
        var cells = row.getElementsByTagName('td');
        
        if (cells.length > 0) {
            var invoice = cells[0].textContent.toLowerCase();
            var customer = cells[2].textContent.toLowerCase();
            var jenis = cells[3].textContent.toLowerCase();
            var status = cells[4].textContent.toLowerCase();
            
            var matchSearch = invoice.includes(searchValue) || customer.includes(searchValue);
            var matchJenis = filterJenis === '' || jenis.includes(filterJenis);
            var matchStatus = filterStatus === '' || status.includes(filterStatus);
            
            if (matchSearch && matchJenis && matchStatus) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        }
    }
}

// Hapus data function
function hapusData(id, invoice) {
    if (confirm('Apakah Anda yakin ingin menghapus penjualan ' + invoice + '?')) {
        // Redirect ke script hapus atau buat AJAX request
        window.location.href = 'penjualan_hapus.php?id=' + id;
    }
}

// Prevent form submit conflicts
document.addEventListener('DOMContentLoaded', function() {
    // Pastikan tidak ada event listener yang menghalangi navigasi
    var editButtons = document.querySelectorAll('a[href*="penjualan_form.php"]');
    editButtons.forEach(function(button) {
        button.addEventListener('click', function(e) {
            // Allow normal navigation
            return true;
        });
    });
});

// Debug function - uncomment untuk debugging
// window.addEventListener('beforeunload', function(e) {
//     console.log('Page is being unloaded');
// });
</script>

</body>
</html>