<?php
include 'config.php';
include 'session.php';
include 'navbar.php';

// Ambil daftar supplier
$supplier_list = array();
$q_supplier = mysqli_query($conn, "SELECT id, nama FROM supplier ORDER BY nama");
while ($row = mysqli_fetch_assoc($q_supplier)) {
    $supplier_list[] = $row;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$data = array(
    'no_invoice' => '',
    'tanggal' => date('Y-m-d'),
    'jenis' => '',
    'customer_id' => '',
    'rekening_id' => '',
    'rekening' => '',
    'status_bayar' => 'belum_bayar',
    'tanggal_bayar' => null,
    'keterangan_bayar' => ''
);
$detail = array();
$is_readonly = false;

if ($id) {
    // Cek apakah kolom rekening_id sudah ada
    $check_column = mysqli_query($conn, "SHOW COLUMNS FROM penjualan LIKE 'rekening_id'");
    $has_rekening_id = mysqli_num_rows($check_column) > 0;
    
    if ($has_rekening_id) {
        $q = mysqli_query($conn, "
            SELECT p.*, r.nama_rekening, r.nama_bank, r.nomor_rekening 
            FROM penjualan p
            LEFT JOIN rekening r ON p.rekening_id = r.id
            WHERE p.id = '$id'
        ");
    } else {
        $q = mysqli_query($conn, "SELECT * FROM penjualan WHERE id = '$id'");
    }
    
    if ($q && $row = mysqli_fetch_assoc($q)) {
        $data = $row;
        $is_readonly = ($data['status_bayar'] == 'lunas');
    }

    // Ambil detail
    $q_detail = mysqli_query($conn, "
        SELECT d.*, pr.nama 
        FROM penjualan_detail d
        JOIN produk_interest pr ON d.produk_id = pr.id
        WHERE d.penjualan_id = '$id'
    ");
    if ($q_detail) {
        while ($d = mysqli_fetch_assoc($q_detail)) {
            $detail[] = $d;
        }
    }
}

// Auto-generate no_invoice - RESET SETIAP BULAN
if (!$id && empty($data['no_invoice'])) {
    $bulan_ini = date('Ym'); // Format: 202510
    
    // Cari nomor urut terakhir di bulan ini
    $q = mysqli_query($conn, "
        SELECT no_invoice 
        FROM penjualan 
        WHERE no_invoice LIKE 'INV-$bulan_ini-%' 
        ORDER BY no_invoice DESC 
        LIMIT 1
    ");
    
    if ($q && mysqli_num_rows($q) > 0) {
        // Ambil nomor terakhir dan tambah 1
        $row = mysqli_fetch_assoc($q);
        $last_no = $row['no_invoice']; // Contoh: INV-202510-0025
        $parts = explode('-', $last_no);
        $last_urut = isset($parts[2]) ? (int)$parts[2] : 0;
        $next_urut = $last_urut + 1;
    } else {
        // Bulan baru, mulai dari 1
        $next_urut = 1;
    }
    
    // Format: INV-202510-0001
    $next = str_pad($next_urut, 4, '0', STR_PAD_LEFT);
    $data['no_invoice'] = "INV-$bulan_ini-$next";
}

// Ambil daftar rekening
$rekening_list = array();
$table_check = mysqli_query($conn, "SHOW TABLES LIKE 'rekening'");
if (mysqli_num_rows($table_check) > 0) {
    $q_rekening = mysqli_query($conn, "SELECT id, nama_rekening, nama_bank, nomor_rekening FROM rekening WHERE aktif = 1 ORDER BY nama_rekening");
    if ($q_rekening) {
        while ($row = mysqli_fetch_assoc($q_rekening)) {
            $rekening_list[] = $row;
        }
    }
}

// Fallback rekening hardcoded
if (empty($rekening_list)) {
    $rekening_list = array(
        array('id' => 1, 'nama_rekening' => 'SUMBER BERKAT ANAK', 'nama_bank' => 'MANDIRI', 'nomor_rekening' => '1372010242304'),
        array('id' => 2, 'nama_rekening' => 'ANGKASA MITRA NIAGA - BRI', 'nama_bank' => 'BRI', 'nomor_rekening' => '0123456789012'),
        array('id' => 3, 'nama_rekening' => 'AHMAD ANDIK NURFIANSYAH', 'nama_bank' => 'BCA', 'nomor_rekening' => '1234567890'),
        array('id' => 4, 'nama_rekening' => 'ANGKASA MITRA NIAGA CV - BCA', 'nama_bank' => 'BCA', 'nomor_rekening' => '1111222233'),
        array('id' => 5, 'nama_rekening' => 'HARTONO MULTI REJEKI', 'nama_bank' => 'BCA', 'nomor_rekening' => '1900332013')
    );
}

// Ambil daftar produk
$produk_list = array();
$q_produk = mysqli_query($conn, "SELECT id, nama FROM produk_interest ORDER BY nama");
if ($q_produk) {
    while ($row = mysqli_fetch_assoc($q_produk)) {
        $produk_list[] = $row;
    }
}

// Ambil daftar customer
$customer_list = array();
$q_customer = mysqli_query($conn, "SELECT id, nama, kode FROM customer WHERE aktif = 1 ORDER BY nama");
if ($q_customer) {
    while ($row = mysqli_fetch_assoc($q_customer)) {
        $customer_list[] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $id ? 'Edit' : 'Input'; ?> Penjualan - SBA System</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet" />
    
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: #f8f9fa;
            color: #333;
        }
        
        .container { 
            max-width: 1200px; 
            margin: 0 auto; 
            padding: 20px; 
        }
        
        .form-control, .form-select { 
            border: 1px solid #ddd; 
            border-radius: 6px; 
            padding: 8px 12px; 
        }
        
        .btn { 
            border-radius: 6px; 
            padding: 8px 16px; 
            font-weight: 500; 
            text-decoration: none; 
        }
        
        .btn-primary { background: #007bff; color: white; border: none; }
        .btn-success { background: #28a745; color: white; border: none; }
        .btn-info { background: #17a2b8; color: white; border: none; }
        .btn-danger { background: #dc3545; color: white; border: none; }
        .btn-secondary { background: #6c757d; color: white; border: none; }
        
        .alert-warning { 
            background: #fff3cd; 
            border: 1px solid #ffeaa7; 
            color: #856404; 
        }
        
        .badge { 
            padding: 4px 8px; 
            border-radius: 4px; 
            font-size: 11px; 
        }
        
        .bg-success { background: #28a745 !important; color: white; }
        .bg-warning { background: #ffc107 !important; color: #333; }
        
        /* TABLE CONTAINER - DYNAMIC HEIGHT */
        .table-container {
            margin-bottom: 50px;
            position: relative;
            background: white;
            border-radius: 8px;
            padding: 15px;
            overflow: visible;
        }
        
        .table { 
            background: white; 
            border-radius: 8px; 
            overflow: visible;
            margin-bottom: 20px;
        }
        
        #produk-table tbody tr {
            height: 60px;
        }
        
        #produk-table tbody td {
            vertical-align: middle;
            padding: 10px 8px;
        }
        
        #produk-table th:first-child,
        #produk-table td:first-child {
            width: 300px;
            min-width: 300px;
        }
        
        /* CUSTOM DROPDOWN SEARCH STYLES */
        .search-dropdown {
            position: relative;
        }
        
        .search-input {
            background: white;
            border: 1px solid #ddd;
            border-radius: 6px;
            padding: 8px 12px;
            width: 100%;
        }
        
        .search-input:focus {
            border-color: #86b7fe;
            outline: 0;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
        
        .search-results {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: white;
            border: 1px solid #ddd;
            border-top: none;
            border-radius: 0 0 6px 6px;
            max-height: 250px;
            overflow-y: auto;
            z-index: 1050;
            display: none;
        }
        
        .search-item {
            padding: 10px 12px;
            cursor: pointer;
            border-bottom: 1px solid #f0f0f0;
        }
        
        .search-item:hover,
        .search-item.active {
            background-color: #f8f9fa;
        }
        
        .search-item:last-child {
            border-bottom: none;
        }
        
        .search-item strong {
            color: #333;
        }
        
        .search-item small {
            color: #666;
            display: block;
            margin-top: 2px;
        }
        
        .rekening-info { 
            font-size: 12px; 
            color: #6c757d; 
            margin-top: 4px; 
        }
        
        .rekening-detail { 
            background: #f8f9fa; 
            border: 1px solid #e9ecef; 
            border-radius: 4px; 
            padding: 8px; 
        }
        
        input[readonly] {
            background-color: #e9ecef;
            opacity: 1;
        }
        
        .no-results {
            padding: 10px 12px;
            color: #666;
            font-style: italic;
        }
    </style>
</head>
<body>

<div class="container mt-4">
    <?php if ($is_readonly): ?>
    <div class="alert alert-warning">
        <strong>⚠️ Transaksi Sudah Lunas!</strong><br>
        Transaksi ini sudah berstatus LUNAS dan tidak dapat diubah lagi.
        <?php if (!empty($data['tanggal_bayar'])): ?>
            <br>Tanggal Bayar: <?php echo date('d/m/Y', strtotime($data['tanggal_bayar'])); ?>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><?php echo $id ? 'Edit' : 'Input'; ?> Penjualan 
            <?php if ($is_readonly): ?>
                <span class="badge bg-success">LUNAS</span>
            <?php elseif ($id): ?>
                <span class="badge bg-warning">BELUM BAYAR</span>
            <?php endif; ?>
        </h3>
        <div>
            <a href="rekening_list.php" class="btn btn-info btn-sm" target="_blank">Master Rekening</a>
        </div>
    </div>

    <form action="penjualan_simpan.php" method="post" id="form-penjualan">
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($id); ?>">

        <!-- HEADER INFORMATION -->
        <div class="row mb-3">
            <div class="col-md-4">
                <label class="form-label">No. Invoice</label>
                <input type="text" name="no_invoice" class="form-control" required 
                       value="<?php echo htmlspecialchars($data['no_invoice']); ?>"
                       <?php echo $is_readonly ? 'readonly' : ''; ?>>
            </div>
            <div class="col-md-4">
                <label class="form-label">Tanggal</label>
                <input type="date" name="tanggal" class="form-control" required 
                       value="<?php echo $data['tanggal']; ?>"
                       <?php echo $is_readonly ? 'readonly' : ''; ?>>
            </div>
            <div class="col-md-4">
                <label class="form-label">Jenis</label>
                <select name="jenis" class="form-select" required <?php echo $is_readonly ? 'disabled' : ''; ?>>
                    <option value="">-- Pilih Jenis --</option>
                    <option value="PPN" <?php echo $data['jenis'] == 'PPN' ? 'selected' : ''; ?>>PPN</option>
                    <option value="non PPN" <?php echo $data['jenis'] == 'non PPN' ? 'selected' : ''; ?>>Non PPN</option>
                </select>
                <?php if ($is_readonly): ?>
                    <input type="hidden" name="jenis" value="<?php echo htmlspecialchars($data['jenis']); ?>">
                <?php endif; ?>
            </div>
        </div>

        <div class="row mb-3">
            <!-- REKENING DROPDOWN SEARCH -->
            <div class="col-md-4">
                <label class="form-label">Rekening Tujuan</label>
                <div class="search-dropdown">
                    <input type="hidden" name="rekening_id" id="selectedRekeningId" value="<?php echo $data['rekening_id'] ?? ''; ?>" required>
                    <input type="text" 
                           class="search-input" 
                           id="rekeningSearch" 
                           placeholder="Ketik untuk mencari rekening..." 
                           value="<?php 
                               if (!empty($data['rekening_id'])) {
                                   foreach ($rekening_list as $rek) {
                                       if ($rek['id'] == $data['rekening_id']) {
                                           echo $rek['nama_rekening'] . ' - ' . $rek['nama_bank'];
                                           break;
                                       }
                                   }
                               } elseif (!empty($data['rekening'])) {
                                   echo htmlspecialchars($data['rekening']);
                               }
                           ?>"
                           autocomplete="off"
                           <?php echo $is_readonly ? 'readonly' : ''; ?>>
                    
                    <div class="search-results" id="rekeningResults">
                        <?php foreach ($rekening_list as $rek): ?>
                        <div class="search-item rekening-item" 
                             data-id="<?php echo $rek['id']; ?>"
                             data-text="<?php echo $rek['nama_rekening'] . ' - ' . $rek['nama_bank']; ?>"
                             data-bank="<?php echo htmlspecialchars($rek['nama_bank']); ?>"
                             data-nomor="<?php echo htmlspecialchars($rek['nomor_rekening']); ?>">
                            <strong><?php echo htmlspecialchars($rek['nama_rekening']); ?></strong>
                            <small><?php echo htmlspecialchars($rek['nama_bank']); ?> - <?php echo htmlspecialchars($rek['nomor_rekening']); ?></small>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <div id="rekening-info" class="rekening-info" style="display: none;">
                    <div class="mt-2 rekening-detail">
                        <div><strong>Bank:</strong> <span id="info-bank">-</span></div>
                        <div><strong>No. Rek:</strong> <span id="info-nomor">-</span></div>
                    </div>
                </div>
                
                <?php if ($is_readonly && (!empty($data['nama_rekening']) || !empty($data['rekening']))): ?>
                    <div class="rekening-info mt-2">
                        <div class="rekening-detail">
                            <div><strong><?php echo htmlspecialchars($data['nama_rekening'] ?? $data['rekening']); ?></strong></div>
                            <div><?php echo htmlspecialchars($data['nama_bank'] ?? 'Bank tidak diketahui'); ?></div>
                            <div><?php echo htmlspecialchars($data['nomor_rekening'] ?? 'Nomor tidak tersedia'); ?></div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- CUSTOMER DROPDOWN SEARCH -->
            <div class="col-md-8">
                <label class="form-label">Customer</label>
                <div class="search-dropdown">
                    <input type="hidden" name="customer_id" id="selectedCustomerId" value="<?php echo $data['customer_id'] ?? ''; ?>" required>
                    <input type="text" 
                           class="search-input" 
                           id="customerSearch" 
                           placeholder="Ketik untuk mencari customer..." 
                           value="<?php 
                               if (!empty($data['customer_id'])) {
                                   $res = mysqli_query($conn, "SELECT nama, kode FROM customer WHERE id = '" . $data['customer_id'] . "'");
                                   if ($res && $row = mysqli_fetch_assoc($res)) {
                                       echo '[' . $row['kode'] . '] ' . $row['nama'];
                                   }
                               }
                           ?>"
                           autocomplete="off"
                           <?php echo $is_readonly ? 'readonly' : ''; ?>>
                    
                    <div class="search-results" id="customerResults">
                        <?php foreach ($customer_list as $cust): ?>
                        <div class="search-item customer-item" 
                             data-id="<?php echo $cust['id']; ?>"
                             data-text="[<?php echo $cust['kode']; ?>] <?php echo $cust['nama']; ?>">
                            <strong><?php echo htmlspecialchars($cust['kode']); ?></strong> - <?php echo htmlspecialchars($cust['nama']); ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- STATUS PEMBAYARAN -->
        <?php if ($id): ?>
        <div class="row mb-3">
            <div class="col-md-4">
                <label class="form-label">Status Pembayaran</label>
                <select name="status_bayar" id="status_bayar" class="form-select" required>
                    <option value="belum_bayar" <?php echo $data['status_bayar'] == 'belum_bayar' ? 'selected' : ''; ?>>Belum Bayar</option>
                    <option value="lunas" <?php echo $data['status_bayar'] == 'lunas' ? 'selected' : ''; ?>>Lunas</option>
                </select>
            </div>
            <div class="col-md-4">
                <label class="form-label">Tanggal Bayar</label>
                <input type="date" name="tanggal_bayar" id="tanggal_bayar" class="form-control" 
                       value="<?php echo $data['tanggal_bayar']; ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">Keterangan Bayar</label>
                <input type="text" name="keterangan_bayar" class="form-control" 
                       value="<?php echo htmlspecialchars($data['keterangan_bayar']); ?>"
                       placeholder="Misal: Transfer BCA">
            </div>
        </div>
        <?php endif; ?>

        <!-- DETAIL PRODUK -->
        <h5>Detail Produk</h5>
        <div class="table-container">
            <table class="table table-bordered" id="produk-table">
                <thead>
                    <tr>
                        <th>Produk</th>
                        <th>Jumlah</th>
                        <th>Unit</th>
                        <th>Harga</th>
                        <th>Total</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($detail)): ?>
                        <?php foreach ($detail as $index => $row): ?>
                        <tr class="produk-row" data-row-index="<?php echo $index; ?>">
                            <td>
                                <div class="search-dropdown">
                                    <input type="hidden" name="produk_id[]" class="selected-produk-id" value="<?php echo $row['produk_id']; ?>" required>
                                    <input type="text" 
                                           class="search-input produk-search" 
                                           placeholder="Ketik untuk mencari produk..." 
                                           value="<?php echo htmlspecialchars($row['nama']); ?>"
                                           autocomplete="off"
                                           <?php echo $is_readonly ? 'readonly' : ''; ?>>
                                    
                                    <div class="search-results produk-results">
                                        <?php foreach ($produk_list as $prod): ?>
                                        <div class="search-item produk-item" 
                                             data-id="<?php echo $prod['id']; ?>"
                                             data-text="<?php echo htmlspecialchars($prod['nama']); ?>">
                                            <?php echo htmlspecialchars($prod['nama']); ?>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                <input type="hidden" name="supplier[]" value="<?php echo htmlspecialchars($row['supplier'] ?? ''); ?>">
                                <input type="hidden" name="harga_beli[]" value="<?php echo htmlspecialchars($row['harga_beli'] ?? ''); ?>">
                                <input type="hidden" name="nota_nama[]" value="<?php echo htmlspecialchars($row['nota'] ?? ''); ?>">
                            </td>
                            <td>
                                <input type="number" name="jumlah[]" class="form-control qty" 
                                       min="1" value="<?php echo $row['qty']; ?>" required
                                       <?php echo $is_readonly ? 'readonly' : ''; ?>>
                            </td>
                            <td>
                                <input type="text" name="unit[]" class="form-control" 
                                       value="<?php echo htmlspecialchars($row['satuan']); ?>" required
                                       <?php echo $is_readonly ? 'readonly' : ''; ?>>
                            </td>
                            <td>
                                <input type="number" name="harga_jual[]" class="form-control harga" 
                                       step="1" value="<?php echo $row['harga']; ?>" required
                                       <?php echo $is_readonly ? 'readonly' : ''; ?>>
                            </td>
                            <td class="text-end fw-bold total">
                                <?php echo number_format($row['qty'] * $row['harga'], 0, ',', '.'); ?>
                            </td>
                            <td>
                                <button type="button" class="btn btn-info btn-sm me-1" onclick="bukaModal(this)">🛒</button>
                                <?php if (!$is_readonly): ?>
                                    <button type="button" class="btn btn-danger btn-sm" onclick="hapusRow(this)">Hapus</button>
                                <?php else: ?>
                                    <span class="text-muted small">Locked</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr class="produk-row" data-row-index="0">
                            <td>
                                <div class="search-dropdown">
                                    <input type="hidden" name="produk_id[]" class="selected-produk-id" value="" required>
                                    <input type="text" 
                                           class="search-input produk-search" 
                                           placeholder="Ketik untuk mencari produk..." 
                                           value=""
                                           autocomplete="off">
                                    
                                    <div class="search-results produk-results">
                                        <?php foreach ($produk_list as $prod): ?>
                                        <div class="search-item produk-item" 
                                             data-id="<?php echo $prod['id']; ?>"
                                             data-text="<?php echo htmlspecialchars($prod['nama']); ?>">
                                            <?php echo htmlspecialchars($prod['nama']); ?>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                <input type="hidden" name="supplier[]" value="">
                                <input type="hidden" name="harga_beli[]" value="">
                                <input type="hidden" name="nota_nama[]" value="">
                            </td>
                            <td><input type="number" name="jumlah[]" class="form-control qty" min="1" value="1" required></td>
                            <td><input type="text" name="unit[]" class="form-control" placeholder="Unit" required></td>
                            <td><input type="number" name="harga_jual[]" class="form-control harga" step="1" required></td>
                            <td class="text-end fw-bold total">0</td>
                            <td>
                                <button type="button" class="btn btn-info btn-sm me-1" onclick="bukaModal(this)">🛒</button>
                                <button type="button" class="btn btn-danger btn-sm" onclick="hapusRow(this)">Hapus</button>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if (!$is_readonly): ?>
        <button type="button" class="btn btn-primary btn-sm mb-3" onclick="tambahProduk()">+ Tambah Produk</button>
        <?php endif; ?>

        <div class="text-end mb-3">
            <strong>Grand Total: Rp <span id="grand-total">0</span></strong>
        </div>

        <div class="d-flex gap-2 mt-4">
            <?php if (!$is_readonly): ?>
                <button type="submit" class="btn btn-success">Simpan Penjualan</button>
            <?php endif; ?>
            <?php if ($id): ?>
                <a href="penjualan_cetak.php?id=<?php echo $id; ?>" target="_blank" class="btn btn-danger">Cetak PDF</a>
            <?php endif; ?>
            <a href="penjualan_list.php" class="btn btn-secondary">Daftar Penjualan</a>
        </div>
    </form>
</div>

<!-- Modal Supplier -->
<div class="modal fade" id="modalPembelian" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Kelola Data Supplier</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Supplier</label>
                    <select class="form-control" id="supplier">
                        <option value="">-- Pilih Supplier --</option>
                        <?php foreach ($supplier_list as $supplier): ?>
                            <option value="<?php echo $supplier['id']; ?>">
                                <?php echo htmlspecialchars($supplier['nama']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Harga Beli</label>
                    <input type="number" class="form-control" id="harga-beli" placeholder="0">
                </div>
                <div class="mb-3">
                    <label class="form-label">Upload Nota</label>
                    <input type="file" class="form-control" id="nota-file" accept=".pdf,.jpg,.jpeg,.png">
                </div>
                <div id="nota-preview"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                <?php if (!$is_readonly): ?>
                    <button type="button" class="btn btn-primary" onclick="simpanPembelian()">Simpan</button>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
var modalRow = null;
var isReadonly = <?php echo $is_readonly ? 'true' : 'false'; ?>;
var produkList = <?php echo json_encode($produk_list); ?>;
var customerList = <?php echo json_encode($customer_list); ?>;
var rekeningList = <?php echo json_encode($rekening_list); ?>;
var rowCounter = <?php echo !empty($detail) ? count($detail) : 1; ?>;

$(document).ready(function () {
    // Initialize Select2 only for supplier in modal
    $('#supplier').select2({ dropdownParent: $('#modalPembelian'), width: '100%' });

    // Initialize search dropdowns if not readonly
    if (!isReadonly) {
        initCustomerSearch();
        initRekeningSearch();
        initProdukSearch();
    }
    
    // Set initial rekening info if available
    updateRekeningInfo();

    // Status pembayaran handler
    $('#status_bayar').change(function() {
        var status = $(this).val();
        var tanggalBayar = $('#tanggal_bayar');
        
        if (status === 'lunas') {
            tanggalBayar.prop('required', true);
            if (!tanggalBayar.val()) {
                tanggalBayar.val('<?php echo date('Y-m-d'); ?>');
            }
        } else {
            tanggalBayar.prop('required', false);
            tanggalBayar.val('');
        }
    }).trigger('change');

    // Calculate initial totals
    hitungTotal();
});

// CUSTOMER SEARCH FUNCTIONALITY
function initCustomerSearch() {
    var customerSearch = $('#customerSearch');
    var customerResults = $('#customerResults');
    
    customerSearch.on('input focus', function() {
        if (isReadonly) return;
        
        var searchTerm = $(this).val().toLowerCase();
        $('#selectedCustomerId').val('');
        
        // Show/hide results
        var hasResults = false;
        $('.customer-item').each(function() {
            var text = $(this).data('text').toLowerCase();
            if (text.includes(searchTerm)) {
                $(this).show();
                hasResults = true;
            } else {
                $(this).hide();
            }
        });
        
        if (hasResults || searchTerm.length === 0) {
            customerResults.show();
        } else {
            customerResults.hide();
        }
    });
    
    // Customer selection
    $(document).on('click', '.customer-item', function(e) {
        e.preventDefault();
        
        var id = $(this).data('id');
        var text = $(this).data('text');
        
        $('#selectedCustomerId').val(id);
        $('#customerSearch').val(text);
        $('#customerResults').hide();
        
        // Remove validation styling
        $('#customerSearch').removeClass('is-invalid');
    });
}

// REKENING SEARCH FUNCTIONALITY
function initRekeningSearch() {
    var rekeningSearch = $('#rekeningSearch');
    var rekeningResults = $('#rekeningResults');
    
    rekeningSearch.on('input focus', function() {
        if (isReadonly) return;
        
        var searchTerm = $(this).val().toLowerCase();
        $('#selectedRekeningId').val('');
        $('#rekening-info').hide();
        
        // Show/hide results
        var hasResults = false;
        $('.rekening-item').each(function() {
            var text = $(this).data('text').toLowerCase();
            if (text.includes(searchTerm)) {
                $(this).show();
                hasResults = true;
            } else {
                $(this).hide();
            }
        });
        
        if (hasResults || searchTerm.length === 0) {
            rekeningResults.show();
        } else {
            rekeningResults.hide();
        }
    });
    
    // Rekening selection
    $(document).on('click', '.rekening-item', function(e) {
        e.preventDefault();
        
        var id = $(this).data('id');
        var text = $(this).data('text');
        var bank = $(this).data('bank');
        var nomor = $(this).data('nomor');
        
        $('#selectedRekeningId').val(id);
        $('#rekeningSearch').val(text);
        $('#rekeningResults').hide();
        
        // Update info display
        $('#info-bank').text(bank);
        $('#info-nomor').text(nomor);
        $('#rekening-info').show();
        
        // Remove validation styling
        $('#rekeningSearch').removeClass('is-invalid');
    });
}

// PRODUK SEARCH FUNCTIONALITY
function initProdukSearch() {
    // Handle input and focus events
    $(document).on('input focus', '.produk-search', function() {
        if (isReadonly) return;
        
        var searchTerm = $(this).val().toLowerCase();
        var row = $(this).closest('tr');
        var results = row.find('.produk-results');
        
        // Clear selection
        row.find('.selected-produk-id').val('');
        
        // Show/hide results
        var hasResults = false;
        row.find('.produk-item').each(function() {
            var text = $(this).data('text').toLowerCase();
            if (text.includes(searchTerm)) {
                $(this).show();
                hasResults = true;
            } else {
                $(this).hide();
            }
        });
        
        if (hasResults || searchTerm.length === 0) {
            results.show();
        } else {
            results.hide();
        }
    });
    
    // Product selection
    $(document).on('click', '.produk-item', function(e) {
        e.preventDefault();
        
        var id = $(this).data('id');
        var text = $(this).data('text');
        var row = $(this).closest('tr');
        
        row.find('.selected-produk-id').val(id);
        row.find('.produk-search').val(text);
        row.find('.produk-results').hide();
        
        // Remove validation styling
        row.find('.produk-search').removeClass('is-invalid');
    });
}

function updateRekeningInfo() {
    // Show rekening info if already selected (for edit mode)
    if ($('#selectedRekeningId').val()) {
        var selectedId = $('#selectedRekeningId').val();
        var selectedItem = $('.rekening-item[data-id="' + selectedId + '"]');
        if (selectedItem.length > 0) {
            var bank = selectedItem.data('bank');
            var nomor = selectedItem.data('nomor');
            $('#info-bank').text(bank);
            $('#info-nomor').text(nomor);
            $('#rekening-info').show();
        }
    }
}

// ADD PRODUCT ROW
function tambahProduk() {
    rowCounter++;
    var newRowHtml = createProdukRow(rowCounter);
    $('#produk-table tbody').append(newRowHtml);
    hitungTotal();
}

function createProdukRow(index) {
    var produkOptions = '';
    produkList.forEach(function(produk) {
        produkOptions += `
            <div class="search-item produk-item" 
                 data-id="${produk.id}"
                 data-text="${produk.nama}">
                ${produk.nama}
            </div>
        `;
    });
    
    return `
        <tr class="produk-row" data-row-index="${index}">
            <td>
                <div class="search-dropdown">
                    <input type="hidden" name="produk_id[]" class="selected-produk-id" value="" required>
                    <input type="text" 
                           class="search-input produk-search" 
                           placeholder="Ketik untuk mencari produk..." 
                           value=""
                           autocomplete="off">
                    
                    <div class="search-results produk-results">
                        ${produkOptions}
                    </div>
                </div>
                <input type="hidden" name="supplier[]" value="">
                <input type="hidden" name="harga_beli[]" value="">
                <input type="hidden" name="nota_nama[]" value="">
            </td>
            <td><input type="number" name="jumlah[]" class="form-control qty" min="1" value="1" required></td>
            <td><input type="text" name="unit[]" class="form-control" placeholder="Unit" required></td>
            <td><input type="number" name="harga_jual[]" class="form-control harga" step="1" required></td>
            <td class="text-end fw-bold total">0</td>
            <td>
                <button type="button" class="btn btn-info btn-sm me-1" onclick="bukaModal(this)">🛒</button>
                <button type="button" class="btn btn-danger btn-sm" onclick="hapusRow(this)">Hapus</button>
            </td>
        </tr>
    `;
}

// REMOVE PRODUCT ROW
function hapusRow(btn) {
    var row = btn.closest('tr');
    var tbody = row.parentElement;
    
    if (tbody.querySelectorAll('tr').length > 1) {
        row.remove();
        hitungTotal();
    } else {
        alert('Minimal harus ada 1 produk!');
    }
}

// CALCULATE TOTALS
document.addEventListener('input', function (e) {
    if (e.target.classList.contains('qty') || e.target.classList.contains('harga')) {
        hitungTotal();
    }
});

function hitungTotal() {
    var grandTotal = 0;
    var rows = document.querySelectorAll('#produk-table tbody tr');
    
    for (var i = 0; i < rows.length; i++) {
        var row = rows[i];
        var qtyEl = row.querySelector('.qty');
        var hargaEl = row.querySelector('.harga');
        var totalEl = row.querySelector('.total');
        
        if (qtyEl && hargaEl && totalEl) {
            var qty = parseFloat(qtyEl.value) || 0;
            var harga = parseFloat(hargaEl.value) || 0;
            var total = qty * harga;
            
            totalEl.textContent = total.toLocaleString('id-ID');
            grandTotal += total;
        }
    }
    
    document.getElementById('grand-total').textContent = grandTotal.toLocaleString('id-ID');
}

// SUPPLIER MODAL FUNCTIONS
function bukaModal(button) {
    var row = button.closest('tr');
    modalRow = row;

    // Get existing data
    var supplierInput = row.querySelector('input[name="supplier[]"]');
    var supplierValue = supplierInput ? supplierInput.value : '';
    
    var hargaBeliInput = row.querySelector('input[name="harga_beli[]"]');
    var hargaBeliValue = hargaBeliInput ? hargaBeliInput.value : '';
    
    var notaInput = row.querySelector('input[name="nota_nama[]"]');
    var notaNama = notaInput ? notaInput.value : '';

    // Set values in modal
    $('#supplier').val(supplierValue).trigger('change');
    document.getElementById('harga-beli').value = hargaBeliValue;

    // Preview nota
    var previewDiv = document.getElementById('nota-preview');
    previewDiv.innerHTML = '';

    if (notaNama) {
        var ekstensi = notaNama.split('.').pop().toLowerCase();
        var url = 'nota_uploads/' + notaNama;

        if (['jpg', 'jpeg', 'png'].includes(ekstensi)) {
            previewDiv.innerHTML = '<div class="alert alert-info">' +
                '<strong>File nota:</strong> ' + notaNama + '<br>' +
                '<a href="' + url + '" target="_blank" class="btn btn-sm btn-outline-primary mt-1">Lihat Gambar</a>' +
                '</div>';
        } else if (ekstensi === 'pdf') {
            previewDiv.innerHTML = '<div class="alert alert-info">' +
                '<strong>File nota:</strong> ' + notaNama + '<br>' +
                '<a href="' + url + '" target="_blank" class="btn btn-sm btn-outline-danger mt-1">Lihat PDF</a>' +
                '</div>';
        }
    } else {
        previewDiv.innerHTML = '<div class="text-muted small">Belum ada file nota yang diupload</div>';
    }

    var modal = new bootstrap.Modal(document.getElementById('modalPembelian'));
    modal.show();
}

function simpanPembelian() {
    if (!modalRow || isReadonly) {
        if (isReadonly) {
            alert('Transaksi sudah lunas, tidak dapat mengubah data supplier!');
        }
        return;
    }

    var supplierValue = document.getElementById('supplier').value;
    var hargaBeli = document.getElementById('harga-beli').value;
    var notaFile = document.getElementById('nota-file').files[0];

    // Update hidden inputs
    tambahAtauUpdateInput(modalRow, 'supplier[]', supplierValue);
    tambahAtauUpdateInput(modalRow, 'harga_beli[]', hargaBeli);

    if (notaFile) {
        if (notaFile.size > 2 * 1024 * 1024) {
            alert('Ukuran file terlalu besar! Maksimal 2MB');
            return;
        }

        var modal = bootstrap.Modal.getInstance(document.getElementById('modalPembelian'));
        var saveBtn = modal._element.querySelector('.btn-primary');
        if (saveBtn) {
            var originalText = saveBtn.innerHTML;
            saveBtn.innerHTML = 'Mengupload...';
            saveBtn.disabled = true;
        }

        var formData = new FormData();
        formData.append('nota', notaFile);
        
        fetch('upload_nota.php', {
            method: 'POST',
            body: formData
        })
        .then(function(response) {
            return response.text();
        })
        .then(function(namaFile) {
            if (namaFile.indexOf('ERROR:') === 0) {
                throw new Error(namaFile);
            }
            tambahAtauUpdateInput(modalRow, 'nota_nama[]', namaFile.trim());
            alert('Nota berhasil diupload!');
            modal.hide();
        })
        .catch(function(err) {
            alert('Gagal mengupload nota: ' + err.message);
        })
        .finally(function() {
            if (saveBtn) {
                saveBtn.innerHTML = originalText;
                saveBtn.disabled = false;
            }
        });
    } else {
        bootstrap.Modal.getInstance(document.getElementById('modalPembelian')).hide();
    }

    alert('Data supplier berhasil disimpan!');
}

function tambahAtauUpdateInput(row, name, value) {
    var input = row.querySelector('input[name="' + name + '"]');
    if (!input) {
        input = document.createElement('input');
        input.type = 'hidden';
        input.name = name;
        row.appendChild(input);
    }
    input.value = value;
}

// CLOSE DROPDOWNS WHEN CLICKING OUTSIDE
$(document).on('click', function(e) {
    if (!$(e.target).closest('.search-dropdown').length) {
        $('.search-results').hide();
    }
});

// FORM VALIDATION
$('#form-penjualan').on('submit', function(e) {
    if (isReadonly) {
        e.preventDefault();
        alert('Transaksi sudah lunas dan tidak dapat diubah!');
        return;
    }

    let isValid = true;
    
    // Validate customer
    if (!$('#selectedCustomerId').val()) {
        $('#customerSearch').addClass('is-invalid');
        isValid = false;
    }
    
    // Validate rekening
    if (!$('#selectedRekeningId').val()) {
        $('#rekeningSearch').addClass('is-invalid');
        isValid = false;
    }

    // Validate products
    var rows = document.querySelectorAll('#produk-table tbody tr');
    var emptyRows = 0;

    for (var i = 0; i < rows.length; i++) {
        var row = rows[i];
        var produkIdEl = row.querySelector('.selected-produk-id');
        var qtyInput = row.querySelector('input[name="jumlah[]"]');
        var hargaInput = row.querySelector('input[name="harga_jual[]"]');

        if (produkIdEl && qtyInput && hargaInput) {
            var produkId = produkIdEl.value;
            if (!produkId || !qtyInput.value || !hargaInput.value) {
                emptyRows++;
                if (!produkId) {
                    var produkSearch = row.querySelector('.produk-search');
                    if (produkSearch) {
                        produkSearch.classList.add('is-invalid');
                    }
                }
            }
        }
    }

    if (emptyRows > 0 || !isValid) {
        e.preventDefault();
        let message = '';
        if (!isValid) {
            message += 'Mohon pilih customer dan rekening terlebih dahulu!\n';
        }
        if (emptyRows > 0) {
            message += 'Mohon lengkapi semua data produk!';
        }
        alert(message);
        return;
    }

    // Show loading state
    var submitBtn = e.target.querySelector('button[type="submit"]');
    if (submitBtn) {
        var originalText = submitBtn.innerHTML;
        submitBtn.innerHTML = 'Menyimpan...';
        submitBtn.disabled = true;
        
        setTimeout(function() {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        }, 10000);
    }
});

// Clear validation errors when user starts typing
$('#customerSearch, #rekeningSearch').on('input', function() {
    $(this).removeClass('is-invalid');
});

$(document).on('input', '.produk-search', function() {
    $(this).removeClass('is-invalid');
});

// Initialize totals on page load
window.addEventListener('DOMContentLoaded', hitungTotal);
</script>

</body>
</html>