<?php
include 'config.php';
include 'session.php';
include 'navbar.php';

// Ambil data draft
$q = mysqli_query($conn, "
    SELECT pd.id, pd.no_draft, pd.tanggal, pd.jenis, pd.rekening, pd.grand_total, c.nama AS customer
    FROM penjualan_draft pd
    JOIN customer c ON pd.customer_id = c.id
    ORDER BY pd.id DESC
");
?>
<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>Daftar Penjualan Draft</h3>
        <a href="penjualan_draft_form.php" class="btn btn-primary">+ Tambah Baru</a>
    </div>
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>No</th>
                <th>No Draft</th>
                <th>Tanggal</th>
                <th>Jenis</th>
                <th>Rekening</th>
                <th>Customer</th>
                <th>Grand Total</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $no = 1; while($row = mysqli_fetch_assoc($q)): ?>
                <tr>
                    <td><?= $no++ ?></td>
                    <td><?= htmlspecialchars($row['no_draft']) ?></td>
                    <td><?= date('d-m-Y', strtotime($row['tanggal'])) ?></td>
                    <td><?= $row['jenis'] ?></td>
                    <td><?= htmlspecialchars($row['rekening']) ?></td>
                    <td><?= htmlspecialchars($row['customer']) ?></td>
                    <td class="text-end"><?= number_format($row['grand_total'], 0, ',', '.') ?></td>
                    <td>
                        <a href="penjualan_draft_form.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm">Edit</a>
                    </td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
