<?php
include 'config.php';
include 'session.php';
include 'navbar.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$data = array(
    'no_pembelian' => '',
    'tanggal' => date('Y-m-d'),
    'supplier_id' => '',
    'total_amount' => 0,
    'keterangan' => '',
    'status' => 'confirmed'
);
$detail = array();

if ($id) {
    // Ambil data header
    $q = mysqli_query($conn, "
        SELECT p.*, s.nama as supplier_nama 
        FROM pembelian p
        LEFT JOIN supplier s ON p.supplier_id = s.id
        WHERE p.id = '$id'
    ");
    if ($q && $row = mysqli_fetch_assoc($q)) {
        $data = $row;
    }

    // Ambil detail
    $q_detail = mysqli_query($conn, "
        SELECT pd.*, pr.nama as produk_nama
        FROM pembelian_detail pd
        JOIN produk_interest pr ON pd.produk_id = pr.id
        WHERE pd.pembelian_id = '$id'
        ORDER BY pd.id
    ");
    if ($q_detail) {
        while ($d = mysqli_fetch_assoc($q_detail)) {
            $detail[] = $d;
        }
    }
}

// Auto-generate no_pembelian jika baru
if (!$id && empty($data['no_pembelian'])) {
    $tahun = date('Y');
    $q = mysqli_query($conn, "
        SELECT COALESCE(MAX(CAST(SUBSTRING(no_pembelian, -4) AS UNSIGNED)), 0) + 1 as next_num
        FROM pembelian 
        WHERE YEAR(tanggal) = '$tahun'
    ");
    if ($q && $row = mysqli_fetch_assoc($q)) {
        $next = str_pad($row['next_num'], 4, '0', STR_PAD_LEFT);
        $data['no_pembelian'] = "PB$tahun$next";
    }
}

// Ambil daftar supplier
$supplier_list = array();
$q_supplier = mysqli_query($conn, "SELECT id, nama FROM supplier ORDER BY nama");
if ($q_supplier) {
    while ($row = mysqli_fetch_assoc($q_supplier)) {
        $supplier_list[] = $row;
    }
}

// Ambil daftar produk
$produk_list = array();
$q_produk = mysqli_query($conn, "SELECT id, nama FROM produk_interest ORDER BY nama");
if ($q_produk) {
    while ($row = mysqli_fetch_assoc($q_produk)) {
        $produk_list[] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $id ? 'Edit' : 'Input'; ?> Pembelian - SBA System</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: #f8f9fa;
            color: #333;
        }
        
        .container { 
            max-width: 1200px; 
            margin: 0 auto; 
            padding: 20px; 
        }
        
        .form-control, .form-select { 
            border: 1px solid #ddd; 
            border-radius: 6px; 
            padding: 8px 12px; 
        }
        
        .btn { 
            border-radius: 6px; 
            padding: 8px 16px; 
            font-weight: 500; 
            text-decoration: none; 
        }
        
        .btn-primary { background: #007bff; color: white; border: none; }
        .btn-success { background: #28a745; color: white; border: none; }
        .btn-info { background: #17a2b8; color: white; border: none; }
        .btn-danger { background: #dc3545; color: white; border: none; }
        .btn-secondary { background: #6c757d; color: white; border: none; }
        
        .table-container {
            margin-bottom: 50px;
            position: relative;
            background: white;
            border-radius: 8px;
            padding: 15px;
            overflow: visible;
        }
        
        .table { 
            background: white; 
            border-radius: 8px; 
            overflow: visible;
            margin-bottom: 20px;
        }
        
        #produk-table tbody tr {
            height: 60px;
        }
        
        #produk-table tbody td {
            vertical-align: middle;
            padding: 10px 8px;
        }
        
        /* Search dropdown styles */
        .search-dropdown {
            position: relative;
        }
        
        .search-input {
            background: white;
            border: 1px solid #ddd;
            border-radius: 6px;
            padding: 8px 12px;
            width: 100%;
        }
        
        .search-input:focus {
            border-color: #86b7fe;
            outline: 0;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }
        
        .search-results {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: white;
            border: 1px solid #ddd;
            border-top: none;
            border-radius: 0 0 6px 6px;
            max-height: 250px;
            overflow-y: auto;
            z-index: 1050;
            display: none;
        }
        
        .search-item {
            padding: 10px 12px;
            cursor: pointer;
            border-bottom: 1px solid #f0f0f0;
        }
        
        .search-item:hover,
        .search-item.active {
            background-color: #f8f9fa;
        }
        
        .search-item:last-child {
            border-bottom: none;
        }
        
        .stock-info {
            font-size: 11px;
            color: #666;
            margin-top: 2px;
        }
        
        .badge-stock {
            font-size: 10px;
            padding: 2px 6px;
        }
    </style>
</head>
<body>

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><?php echo $id ? 'Edit' : 'Input'; ?> Pembelian</h3>
        <div>
            <a href="pembelian_list.php" class="btn btn-info btn-sm">Daftar Pembelian</a>
            <a href="supplier_list.php" class="btn btn-info btn-sm" target="_blank">Master Supplier</a>
        </div>
    </div>

    <form action="pembelian_simpan.php" method="post" id="form-pembelian" enctype="multipart/form-data">
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($id); ?>">

        <!-- HEADER INFORMATION -->
        <div class="row mb-3">
            <div class="col-md-3">
                <label class="form-label">No. Pembelian</label>
                <input type="text" name="no_pembelian" class="form-control" required 
                       value="<?php echo htmlspecialchars($data['no_pembelian']); ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">Tanggal</label>
                <input type="date" name="tanggal" class="form-control" required 
                       value="<?php echo $data['tanggal']; ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">Supplier</label>
                <select name="supplier_id" class="form-select" required>
                    <option value="">-- Pilih Supplier --</option>
                    <?php foreach ($supplier_list as $supplier): ?>
                    <option value="<?php echo $supplier['id']; ?>" 
                            <?php echo $data['supplier_id'] == $supplier['id'] ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($supplier['nama']); ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="confirmed" <?php echo $data['status'] == 'confirmed' ? 'selected' : ''; ?>>Confirmed</option>
                    <option value="draft" <?php echo $data['status'] == 'draft' ? 'selected' : ''; ?>>Draft</option>
                </select>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-md-12">
                <label class="form-label">Keterangan</label>
                <input type="text" name="keterangan" class="form-control" 
                       value="<?php echo htmlspecialchars($data['keterangan']); ?>"
                       placeholder="Keterangan pembelian...">
            </div>
        </div>

        <!-- DETAIL PRODUK -->
        <h5>Detail Produk</h5>
        <div class="table-container">
            <table class="table table-bordered" id="produk-table">
                <thead>
                    <tr>
                        <th width="25%">Produk</th>
                        <th width="10%">Qty Beli</th>
                        <th width="10%">Satuan</th>
                        <th width="15%">Harga Beli</th>
                        <th width="15%">Subtotal</th>
                        <th width="15%">Nota</th>
                        <th width="10%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($detail)): ?>
                        <?php foreach ($detail as $index => $row): ?>
                        <tr class="produk-row" data-row-index="<?php echo $index; ?>">
                            <td>
                                <div class="search-dropdown">
                                    <input type="hidden" name="produk_id[]" class="selected-produk-id" value="<?php echo $row['produk_id']; ?>" required>
                                    <input type="text" 
                                           class="search-input produk-search" 
                                           placeholder="Ketik untuk mencari produk..." 
                                           value="<?php echo htmlspecialchars($row['produk_nama']); ?>"
                                           autocomplete="off">
                                    
                                    <div class="search-results produk-results">
                                        <?php foreach ($produk_list as $prod): ?>
                                        <div class="search-item produk-item" 
                                             data-id="<?php echo $prod['id']; ?>"
                                             data-text="<?php echo htmlspecialchars($prod['nama']); ?>">
                                            <?php echo htmlspecialchars($prod['nama']); ?>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                
                                <?php if ($id): ?>
                                <div class="stock-info">
                                    <span class="badge badge-stock bg-<?php echo $row['qty_tersisa'] > 0 ? 'success' : 'danger'; ?>">
                                        Sisa: <?php echo $row['qty_tersisa']; ?> / <?php echo $row['qty_beli']; ?>
                                    </span>
                                </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <input type="number" name="qty_beli[]" class="form-control qty" 
                                       min="0.01" step="0.01" value="<?php echo $row['qty_beli']; ?>" required>
                            </td>
                            <td>
                                <input type="text" name="satuan[]" class="form-control" 
                                       value="<?php echo htmlspecialchars($row['satuan']); ?>" required>
                            </td>
                            <td>
                                <input type="number" name="harga_beli[]" class="form-control harga" 
                                       step="1" value="<?php echo $row['harga_beli']; ?>" required>
                            </td>
                            <td class="text-end fw-bold subtotal">
                                <?php echo number_format($row['qty_beli'] * $row['harga_beli'], 0, ',', '.'); ?>
                            </td>
                            <td>
                                <input type="file" name="nota_file[]" class="form-control form-control-sm" 
                                       accept=".pdf,.jpg,.jpeg,.png">
                                <input type="hidden" name="nota_existing[]" value="">
                                <div class="nota-preview mt-1"></div>
                            </td>
                            <td>
                                <button type="button" class="btn btn-danger btn-sm" onclick="hapusRow(this)">Hapus</button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr class="produk-row" data-row-index="0">
                            <td>
                                <div class="search-dropdown">
                                    <input type="hidden" name="produk_id[]" class="selected-produk-id" value="" required>
                                    <input type="text" 
                                           class="search-input produk-search" 
                                           placeholder="Ketik untuk mencari produk..." 
                                           value=""
                                           autocomplete="off">
                                    
                                    <div class="search-results produk-results">
                                        <?php foreach ($produk_list as $prod): ?>
                                        <div class="search-item produk-item" 
                                             data-id="<?php echo $prod['id']; ?>"
                                             data-text="<?php echo htmlspecialchars($prod['nama']); ?>">
                                            <?php echo htmlspecialchars($prod['nama']); ?>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </td>
                            <td><input type="number" name="qty_beli[]" class="form-control qty" min="0.01" step="0.01" value="1" required></td>
                            <td><input type="text" name="satuan[]" class="form-control" placeholder="PCS" required></td>
                            <td><input type="number" name="harga_beli[]" class="form-control harga" step="1" required></td>
                            <td class="text-end fw-bold subtotal">0</td>
                            <td>
                                <input type="file" name="nota_file[]" class="form-control form-control-sm" 
                                       accept=".pdf,.jpg,.jpeg,.png">
                                <input type="hidden" name="nota_existing[]" value="">
                                <div class="nota-preview mt-1"></div>
                            </td>
                            <td>
                                <button type="button" class="btn btn-danger btn-sm" onclick="hapusRow(this)">Hapus</button>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <button type="button" class="btn btn-primary btn-sm mb-3" onclick="tambahProduk()">+ Tambah Produk</button>

        <div class="text-end mb-3">
            <strong>Total Pembelian: Rp <span id="grand-total">0</span></strong>
        </div>

        <div class="d-flex gap-2 mt-4">
            <button type="submit" class="btn btn-success">Simpan Pembelian</button>
            <?php if ($id): ?>
                <a href="pembelian_cetak.php?id=<?php echo $id; ?>" target="_blank" class="btn btn-danger">Cetak PDF</a>
            <?php endif; ?>
            <a href="pembelian_list.php" class="btn btn-secondary">Daftar Pembelian</a>
        </div>
    </form>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
var produkList = <?php echo json_encode($produk_list); ?>;
var rowCounter = <?php echo !empty($detail) ? count($detail) : 1; ?>;

$(document).ready(function () {
    initProdukSearch();
    hitungTotal();
});

// PRODUK SEARCH FUNCTIONALITY
function initProdukSearch() {
    $(document).on('input focus', '.produk-search', function() {
        var searchTerm = $(this).val().toLowerCase();
        var row = $(this).closest('tr');
        var results = row.find('.produk-results');
        
        // Clear selection
        row.find('.selected-produk-id').val('');
        
        // Show/hide results
        var hasResults = false;
        row.find('.produk-item').each(function() {
            var text = $(this).data('text').toLowerCase();
            if (text.includes(searchTerm)) {
                $(this).show();
                hasResults = true;
            } else {
                $(this).hide();
            }
        });
        
        if (hasResults || searchTerm.length === 0) {
            results.show();
        } else {
            results.hide();
        }
    });
    
    // Product selection
    $(document).on('click', '.produk-item', function(e) {
        e.preventDefault();
        
        var id = $(this).data('id');
        var text = $(this).data('text');
        var row = $(this).closest('tr');
        
        row.find('.selected-produk-id').val(id);
        row.find('.produk-search').val(text);
        row.find('.produk-results').hide();
        
        row.find('.produk-search').removeClass('is-invalid');
    });
}

// ADD PRODUCT ROW
function tambahProduk() {
    rowCounter++;
    var newRowHtml = createProdukRow(rowCounter);
    $('#produk-table tbody').append(newRowHtml);
    hitungTotal();
}

function createProdukRow(index) {
    var produkOptions = '';
    produkList.forEach(function(produk) {
        produkOptions += `
            <div class="search-item produk-item" 
                 data-id="${produk.id}"
                 data-text="${produk.nama}">
                ${produk.nama}
            </div>
        `;
    });
    
    return `
        <tr class="produk-row" data-row-index="${index}">
            <td>
                <div class="search-dropdown">
                    <input type="hidden" name="produk_id[]" class="selected-produk-id" value="" required>
                    <input type="text" 
                           class="search-input produk-search" 
                           placeholder="Ketik untuk mencari produk..." 
                           value=""
                           autocomplete="off">
                    
                    <div class="search-results produk-results">
                        ${produkOptions}
                    </div>
                </div>
            </td>
            <td><input type="number" name="qty_beli[]" class="form-control qty" min="0.01" step="0.01" value="1" required></td>
            <td><input type="text" name="satuan[]" class="form-control" placeholder="PCS" required></td>
            <td><input type="number" name="harga_beli[]" class="form-control harga" step="1" required></td>
            <td class="text-end fw-bold subtotal">0</td>
            <td>
                <input type="file" name="nota_file[]" class="form-control form-control-sm" 
                       accept=".pdf,.jpg,.jpeg,.png">
                <input type="hidden" name="nota_existing[]" value="">
                <div class="nota-preview mt-1"></div>
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="hapusRow(this)">Hapus</button>
            </td>
        </tr>
    `;
}

// REMOVE PRODUCT ROW
function hapusRow(btn) {
    var row = btn.closest('tr');
    var tbody = row.parentElement;
    
    if (tbody.querySelectorAll('tr').length > 1) {
        row.remove();
        hitungTotal();
    } else {
        alert('Minimal harus ada 1 produk!');
    }
}

// CALCULATE TOTALS
document.addEventListener('input', function (e) {
    if (e.target.classList.contains('qty') || e.target.classList.contains('harga')) {
        hitungTotal();
    }
});

function hitungTotal() {
    var grandTotal = 0;
    var rows = document.querySelectorAll('#produk-table tbody tr');
    
    for (var i = 0; i < rows.length; i++) {
        var row = rows[i];
        var qtyEl = row.querySelector('.qty');
        var hargaEl = row.querySelector('.harga');
        var subtotalEl = row.querySelector('.subtotal');
        
        if (qtyEl && hargaEl && subtotalEl) {
            var qty = parseFloat(qtyEl.value) || 0;
            var harga = parseFloat(hargaEl.value) || 0;
            var subtotal = qty * harga;
            
            subtotalEl.textContent = subtotal.toLocaleString('id-ID');
            grandTotal += subtotal;
        }
    }
    
    document.getElementById('grand-total').textContent = grandTotal.toLocaleString('id-ID');
}

// CLOSE DROPDOWNS WHEN CLICKING OUTSIDE
$(document).on('click', function(e) {
    if (!$(e.target).closest('.search-dropdown').length) {
        $('.search-results').hide();
    }
});

// FORM VALIDATION
$('#form-pembelian').on('submit', function(e) {
    let isValid = true;
    
    // Validate products
    var rows = document.querySelectorAll('#produk-table tbody tr');
    var emptyRows = 0;

    for (var i = 0; i < rows.length; i++) {
        var row = rows[i];
        var produkIdEl = row.querySelector('.selected-produk-id');
        var qtyInput = row.querySelector('input[name="qty_beli[]"]');
        var hargaInput = row.querySelector('input[name="harga_beli[]"]');

        if (produkIdEl && qtyInput && hargaInput) {
            var produkId = produkIdEl.value;
            if (!produkId || !qtyInput.value || !hargaInput.value) {
                emptyRows++;
                if (!produkId) {
                    var produkSearch = row.querySelector('.produk-search');
                    if (produkSearch) {
                        produkSearch.classList.add('is-invalid');
                    }
                }
            }
        }
    }

    if (emptyRows > 0 || !isValid) {
        e.preventDefault();
        if (emptyRows > 0) {
            alert('Mohon lengkapi semua data produk!');
        }
        return;
    }

    // Show loading state
    var submitBtn = e.target.querySelector('button[type="submit"]');
    if (submitBtn) {
        var originalText = submitBtn.innerHTML;
        submitBtn.innerHTML = 'Menyimpan...';
        submitBtn.disabled = true;
        
        setTimeout(function() {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        }, 10000);
    }
});

$(document).on('input', '.produk-search', function() {
    $(this).removeClass('is-invalid');
});

window.addEventListener('DOMContentLoaded', hitungTotal);
</script>

</body>
</html>