<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'config.php';
include 'session.php';

// Check if connection exists
if (!isset($conn) || !$conn) {
    die('Error: Database connection tidak tersedia!');
}

// Get meeting ID
$meeting_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if (!$meeting_id) {
    die('Meeting ID tidak valid');
}

// Check if tables exist first
$meeting_table_check = mysqli_query($conn, "SHOW TABLES LIKE 'meeting'");
if (mysqli_num_rows($meeting_table_check) == 0) {
    die('Tabel meeting belum dibuat. Silakan setup modul meeting terlebih dahulu.');
}

// Get meeting data with basic info first
$meeting_query = "SELECT * FROM meeting WHERE id = $meeting_id";
$meeting_result = mysqli_query($conn, $meeting_query);

if (!$meeting_result) {
    die('Error dalam query meeting: ' . mysqli_error($conn));
}

$meeting = mysqli_fetch_assoc($meeting_result);

if (!$meeting) {
    die('Meeting tidak ditemukan');
}

// Get customer data if exists
$customer_data = null;
if ($meeting['customer_id']) {
    $customer_query = "SELECT * FROM customer WHERE id = " . (int)$meeting['customer_id'];
    $customer_result = mysqli_query($conn, $customer_query);
    if ($customer_result && mysqli_num_rows($customer_result) > 0) {
        $customer_data = mysqli_fetch_assoc($customer_result);
    }
}

// Get supplier data if exists
$supplier_data = null;
if ($meeting['supplier_id']) {
    $supplier_query = "SELECT * FROM supplier WHERE id = " . (int)$meeting['supplier_id'];
    $supplier_result = mysqli_query($conn, $supplier_query);
    if ($supplier_result && mysqli_num_rows($supplier_result) > 0) {
        $supplier_data = mysqli_fetch_assoc($supplier_result);
    }
}

// Get meeting agenda
$agendas = [];
$agenda_query = "SELECT * FROM meeting_agenda WHERE meeting_id = $meeting_id ORDER BY urutan ASC";
$agenda_result = mysqli_query($conn, $agenda_query);
if ($agenda_result) {
    while ($row = mysqli_fetch_assoc($agenda_result)) {
        $agendas[] = $row;
    }
}

// Get meeting participants
$participants = [];
$participant_check = mysqli_query($conn, "SHOW TABLES LIKE 'meeting_peserta'");
if (mysqli_num_rows($participant_check) > 0) {
    $participant_query = "SELECT * FROM meeting_peserta WHERE meeting_id = $meeting_id ORDER BY created_at ASC";
    $participant_result = mysqli_query($conn, $participant_query);
    if ($participant_result) {
        while ($row = mysqli_fetch_assoc($participant_result)) {
            $participants[] = $row;
        }
    }
}

// Get meeting notes
$notes = [];
$notes_check = mysqli_query($conn, "SHOW TABLES LIKE 'meeting_notes'");
if (mysqli_num_rows($notes_check) > 0) {
    $notes_query = "SELECT * FROM meeting_notes WHERE meeting_id = $meeting_id ORDER BY created_at ASC";
    $notes_result = mysqli_query($conn, $notes_query);
    if ($notes_result) {
        while ($row = mysqli_fetch_assoc($notes_result)) {
            $notes[] = $row;
        }
    }
}

// Get meeting action items
$action_items = [];
$action_check = mysqli_query($conn, "SHOW TABLES LIKE 'meeting_action_items'");
if (mysqli_num_rows($action_check) > 0) {
    $action_query = "SELECT * FROM meeting_action_items WHERE meeting_id = $meeting_id ORDER BY created_at ASC";
    $action_result = mysqli_query($conn, $action_query);
    if ($action_result) {
        while ($row = mysqli_fetch_assoc($action_result)) {
            $action_items[] = $row;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Meeting Report - <?php echo htmlspecialchars($meeting['kode_meeting']); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/font-awesome.min.css">
    <style>
        @media print {
            .no-print {
                display: none !important;
            }
            .page-break {
                page-break-before: always;
            }
            body {
                font-size: 12pt;
                line-height: 1.4;
            }
            .signature-section {
                margin-top: 50px;
                page-break-inside: avoid;
            }
        }

        body {
            font-family: Arial, sans-serif;
        }

        .meeting-header {
            border-bottom: 3px solid #007bff;
            padding-bottom: 15px;
            margin-bottom: 25px;
            text-align: center;
        }

        .meeting-info {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 25px;
        }

        .agenda-section {
            margin-bottom: 30px;
        }

        .agenda-item {
            border: 1px solid #dee2e6;
            padding: 15px;
            margin-bottom: 15px;
            border-radius: 5px;
        }

        .participants-section {
            margin-bottom: 30px;
        }

        .signature-section {
            margin-top: 50px;
            border-top: 1px solid #dee2e6;
            padding-top: 30px;
        }

        .signature-box {
            border: 1px solid #000;
            height: 80px;
            margin-top: 10px;
            text-align: center;
            padding-top: 25px;
            background-color: #f9f9f9;
        }

        .info-row {
            margin-bottom: 10px;
        }

        .info-label {
            font-weight: bold;
            color: #495057;
        }

        .company-logo {
            max-height: 60px;
            margin-bottom: 10px;
        }

        .meeting-type-badge {
            display: inline-block;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.9em;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .meeting-type-internal { background-color: #0d6efd; color: white; }
        .meeting-type-external { background-color: #fd7e14; color: white; }
        .meeting-type-customer { background-color: #198754; color: white; }
        .meeting-type-supplier { background-color: #dc3545; color: white; }
        .meeting-type-planning { background-color: #6f42c1; color: white; }
        .meeting-type-review { background-color: #20c997; color: white; }
    </style>
</head>
<body>

<div class="container-fluid">
    <!-- Print Controls -->
    <div class="no-print text-center mb-4">
        <button onclick="window.print()" class="btn btn-primary me-2">
            <i class="fa fa-print"></i> Cetak Meeting
        </button>
        <button onclick="window.close()" class="btn btn-secondary">
            <i class="fa fa-times"></i> Tutup
        </button>
    </div>

    <!-- Meeting Header -->
    <div class="meeting-header">
        <h2 class="mb-3">LAPORAN MEETING</h2>
        <div class="meeting-type-badge meeting-type-<?php echo htmlspecialchars($meeting['jenis_meeting']); ?>">
            <?php echo strtoupper(htmlspecialchars($meeting['jenis_meeting'])); ?>
        </div>
        <h4 class="text-primary mt-2"><?php echo htmlspecialchars($meeting['kode_meeting']); ?></h4>
    </div>

    <!-- Meeting Information -->
    <div class="meeting-info">
        <h5 class="mb-3">INFORMASI MEETING</h5>
        <div class="row">
            <div class="col-md-6">
                <div class="info-row">
                    <span class="info-label">Tanggal:</span>
                    <?php echo date('d F Y', strtotime($meeting['tanggal'])); ?>
                </div>
                <div class="info-row">
                    <span class="info-label">Waktu:</span>
                    <?php if ($meeting['waktu_mulai']): ?>
                        <?php echo date('H:i', strtotime($meeting['waktu_mulai'])); ?>
                        <?php if ($meeting['waktu_selesai']): ?>
                            - <?php echo date('H:i', strtotime($meeting['waktu_selesai'])); ?>
                        <?php endif; ?>
                    <?php else: ?>
                        Tidak ditentukan
                    <?php endif; ?>
                </div>
                <div class="info-row">
                    <span class="info-label">Tempat:</span>
                    <?php echo htmlspecialchars($meeting['tempat']); ?>
                </div>
            </div>
            <div class="col-md-6">
                <?php if ($customer_data): ?>
                    <div class="info-row">
                        <span class="info-label">Customer:</span>
                        <?php echo htmlspecialchars($customer_data['nama']); ?>
                    </div>
                    <?php if ($customer_data['kota']): ?>
                        <div class="info-row">
                            <span class="info-label">Kota Customer:</span>
                            <?php echo htmlspecialchars($customer_data['kota']); ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($customer_data['no_hp']): ?>
                        <div class="info-row">
                            <span class="info-label">No. HP Customer:</span>
                            <?php echo htmlspecialchars($customer_data['no_hp']); ?>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <?php if ($supplier_data): ?>
                    <div class="info-row">
                        <span class="info-label">Supplier:</span>
                        <?php echo htmlspecialchars($supplier_data['nama']); ?>
                    </div>
                    <?php if ($supplier_data['kontak']): ?>
                        <div class="info-row">
                            <span class="info-label">Kontak Supplier:</span>
                            <?php echo htmlspecialchars($supplier_data['kontak']); ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($supplier_data['alamat']): ?>
                        <div class="info-row">
                            <span class="info-label">Alamat Supplier:</span>
                            <?php echo htmlspecialchars($supplier_data['alamat']); ?>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <div class="info-row">
                    <span class="info-label">Dibuat pada:</span>
                    <?php echo date('d F Y H:i', strtotime($meeting['created_at'])); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Meeting Participants -->
    <?php if (!empty($participants)): ?>
        <div class="participants-section">
            <h5 class="mb-3">PESERTA MEETING</h5>
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead class="table-light">
                        <tr>
                            <th>No.</th>
                            <th>Nama</th>
                            <th>Jabatan</th>
                            <th>Peran</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($participants as $index => $participant): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td>
                                    <?php 
                                    if (isset($participant['nama_peserta'])) {
                                        echo htmlspecialchars($participant['nama_peserta']);
                                    } elseif (isset($participant['user_id'])) {
                                        echo "User ID: " . htmlspecialchars($participant['user_id']);
                                    } else {
                                        echo "-";
                                    }
                                    ?>
                                </td>
                                <td><?php echo htmlspecialchars($participant['jabatan'] ?? '-'); ?></td>
                                <td><?php echo htmlspecialchars($participant['peran'] ?? '-'); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>

    <!-- Meeting Agenda -->
    <?php if (!empty($agendas)): ?>
        <div class="agenda-section">
            <h5 class="mb-3">AGENDA MEETING</h5>
            <?php foreach ($agendas as $index => $agenda): ?>
                <div class="agenda-item">
                    <div class="d-flex justify-content-between align-items-start mb-2">
                        <h6 class="mb-0">
                            <?php echo ($index + 1); ?>. <?php echo htmlspecialchars($agenda['subject']); ?>
                        </h6>
                        <?php if (isset($agenda['prioritas']) && $agenda['prioritas']): ?>
                            <span class="badge <?php 
                                echo $agenda['prioritas'] == 'urgent' ? 'bg-danger' : 
                                    ($agenda['prioritas'] == 'high' ? 'bg-warning' : 
                                    ($agenda['prioritas'] == 'medium' ? 'bg-info' : 'bg-secondary')); 
                            ?>">
                                <?php echo ucfirst(htmlspecialchars($agenda['prioritas'])); ?>
                            </span>
                        <?php endif; ?>
                    </div>
                    
                    <?php if (isset($agenda['detail_subject']) && $agenda['detail_subject']): ?>
                        <div class="mb-2">
                            <strong>Detail:</strong><br>
                            <?php echo nl2br(htmlspecialchars($agenda['detail_subject'])); ?>
                        </div>
                    <?php endif; ?>

                    <?php if (isset($agenda['pic_agenda']) && $agenda['pic_agenda']): ?>
                        <div class="mb-2">
                            <strong>PIC:</strong> User ID <?php echo htmlspecialchars($agenda['pic_agenda']); ?>
                        </div>
                    <?php endif; ?>

                    <?php if (isset($agenda['deadline']) && $agenda['deadline']): ?>
                        <div class="mb-2">
                            <strong>Deadline:</strong> <?php echo date('d F Y', strtotime($agenda['deadline'])); ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <!-- Meeting Notes -->
    <?php if (!empty($notes)): ?>
        <div class="notes-section">
            <h5 class="mb-3">CATATAN MEETING</h5>
            <?php foreach ($notes as $note): ?>
                <div class="agenda-item">
                    <div class="mb-2">
                        <strong>Catatan:</strong>
                    </div>
                    <div><?php echo nl2br(htmlspecialchars($note['catatan'])); ?></div>
                    <?php if (isset($note['created_at']) && $note['created_at']): ?>
                        <small class="text-muted">
                            Dibuat: <?php echo date('d M Y H:i', strtotime($note['created_at'])); ?>
                        </small>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <!-- Signature Section -->
    <div class="signature-section">
        <h5 class="mb-4">TANDA TANGAN</h5>
        <div class="row">
            <div class="col-md-4">
                <div class="text-center">
                    <strong>Pimpinan Meeting</strong>
                    <div class="signature-box">
                        
                    </div>
                    <div class="mt-2">
                        <strong>(__________________)</strong><br>
                        <small>Nama & Jabatan</small>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="text-center">
                    <strong>Sekretaris/Notulen</strong>
                    <div class="signature-box">
                        
                    </div>
                    <div class="mt-2">
                        <strong>(__________________)</strong><br>
                        <small>Nama & Jabatan</small>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="text-center">
                    <strong>Mengetahui</strong>
                    <div class="signature-box">
                        
                    </div>
                    <div class="mt-2">
                        <strong>(__________________)</strong><br>
                        <small>Nama & Jabatan</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <div class="mt-5 pt-3" style="border-top: 1px solid #dee2e6;">
        <div class="row">
            <div class="col-6">
                <small class="text-muted">
                    Dokumen dicetak pada: <?php echo date('d F Y H:i:s'); ?>
                </small>
            </div>
            <div class="col-6 text-end">
                <small class="text-muted">
                    Meeting ID: <?php echo $meeting['id']; ?>
                </small>
            </div>
        </div>
    </div>
</div>

<script>
// Print function
function printDocument() {
    window.print();
}

// Close function
function closeWindow() {
    window.close();
}
</script>

</body>
</html>