<?php
include 'config.php';
include 'session.php';

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if connection exists
if (!isset($conn) || !$conn) {
    die('Error: Database connection tidak tersedia!');
}

// Handle delete action
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $meeting_id = (int)$_GET['id'];
    
    // Start transaction
    mysqli_begin_transaction($conn);
    
    try {
        // Delete meeting agenda first (foreign key constraint)
        $delete_agenda = mysqli_query($conn, "DELETE FROM meeting_agenda WHERE meeting_id = $meeting_id");
        
        // Delete meeting participants (menggunakan nama tabel yang benar)
        $participant_check = mysqli_query($conn, "SHOW TABLES LIKE 'meeting_peserta'");
        if (mysqli_num_rows($participant_check) > 0) {
            mysqli_query($conn, "DELETE FROM meeting_peserta WHERE meeting_id = $meeting_id");
        }
        
        // Delete meeting notes if table exists
        $notes_check = mysqli_query($conn, "SHOW TABLES LIKE 'meeting_notes'");
        if (mysqli_num_rows($notes_check) > 0) {
            mysqli_query($conn, "DELETE FROM meeting_notes WHERE meeting_id = $meeting_id");
        }
        
        // Delete meeting action items if table exists
        $action_check = mysqli_query($conn, "SHOW TABLES LIKE 'meeting_action_items'");
        if (mysqli_num_rows($action_check) > 0) {
            mysqli_query($conn, "DELETE FROM meeting_action_items WHERE meeting_id = $meeting_id");
        }
        
        // Delete meeting attachments if table exists
        $attachment_check = mysqli_query($conn, "SHOW TABLES LIKE 'meeting_attachments'");
        if (mysqli_num_rows($attachment_check) > 0) {
            mysqli_query($conn, "DELETE FROM meeting_attachments WHERE meeting_id = $meeting_id");
        }
        
        // Finally delete the meeting
        $delete_meeting = mysqli_query($conn, "DELETE FROM meeting WHERE id = $meeting_id");
        
        if ($delete_meeting) {
            mysqli_commit($conn);
            $_SESSION['success_message'] = "Meeting berhasil dihapus!";
        } else {
            throw new Exception("Gagal menghapus meeting");
        }
        
    } catch (Exception $e) {
        mysqli_rollback($conn);
        $_SESSION['error_message'] = "Error: " . $e->getMessage();
    }
    
    header('Location: meeting_list.php');
    exit();
}

// Check if meeting table exists
$table_check = mysqli_query($conn, "SHOW TABLES LIKE 'meeting'");
if (mysqli_num_rows($table_check) == 0) {
    ?>
    <!DOCTYPE html>
    <html lang="id">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Meeting Module Setup Required</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/font-awesome.min.css">
    </head>
    <body>
        <?php if (file_exists('navbar.php')) include 'navbar.php'; ?>
        <div class="container mt-4">
            <div class="card">
                <div class="card-header bg-warning text-dark">
                    <h4><i class="fa fa-exclamation-triangle"></i> Meeting Module Setup Required</h4>
                </div>
                <div class="card-body">
                    <div class="alert alert-warning">
                        <h5>Tabel Meeting Belum Ada</h5>
                        <p>Modul meeting membutuhkan tabel database yang belum dibuat. Klik tombol di bawah untuk membuat tabel yang diperlukan.</p>
                    </div>
                    
                    <div class="text-center">
                        <button onclick="setupMeetingTables()" class="btn btn-primary btn-lg">
                            <i class="fa fa-cogs"></i> Setup Meeting Module
                        </button>
                        <div id="setupResult" class="mt-3"></div>
                    </div>
                </div>
            </div>
        </div>
        
        <script>
        function setupMeetingTables() {
            document.getElementById('setupResult').innerHTML = '<div class="spinner-border text-primary" role="status"></div><p>Membuat tabel...</p>';
            
            fetch('meeting_setup_simple.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({action: 'create_tables'})
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById('setupResult').innerHTML = '<div class="alert alert-success">✓ Setup berhasil! <a href="meeting_list.php" class="btn btn-sm btn-success ms-2">Reload Page</a></div>';
                } else {
                    document.getElementById('setupResult').innerHTML = '<div class="alert alert-danger">✗ Error: ' + data.message + '</div>';
                }
            })
            .catch(error => {
                document.getElementById('setupResult').innerHTML = '<div class="alert alert-danger">✗ Network error: ' + error + '</div>';
            });
        }
        </script>
    </body>
    </html>
    <?php
    exit();
}

// Initialize variables
$meetings = [];
$total_records = 0;
$total_pages = 1;

// Pagination
$limit = 15;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Search and filter
$search = isset($_GET['search']) ? mysqli_real_escape_string($conn, $_GET['search']) : '';
$jenis_filter = isset($_GET['jenis']) ? mysqli_real_escape_string($conn, $_GET['jenis']) : '';

try {
    // Build WHERE clause
    $where_conditions = [];
    
    if ($search) {
        $where_conditions[] = "(m.kode_meeting LIKE '%$search%' OR m.tempat LIKE '%$search%' OR COALESCE(c.nama, '') LIKE '%$search%' OR COALESCE(s.nama, '') LIKE '%$search%')";
    }

    if ($jenis_filter) {
        $where_conditions[] = "m.jenis_meeting = '$jenis_filter'";
    }

    $where_clause = $where_conditions ? "WHERE " . implode(" AND ", $where_conditions) : "";

    // Get total count for pagination
    $count_sql = "
        SELECT COUNT(DISTINCT m.id) as total
        FROM meeting m
        LEFT JOIN customer c ON m.customer_id = c.id
        LEFT JOIN supplier s ON m.supplier_id = s.id
        $where_clause
    ";

    $count_result = mysqli_query($conn, $count_sql);
    if ($count_result) {
        $count_row = mysqli_fetch_assoc($count_result);
        $total_records = $count_row['total'];
        $total_pages = ceil($total_records / $limit);
    }

    // Get meetings data - simplified query
    $sql = "
        SELECT 
            m.id,
            m.kode_meeting,
            m.tanggal,
            m.waktu_mulai,
            m.waktu_selesai,
            m.tempat,
            m.jenis_meeting,
            m.created_at,
            c.nama as customer_nama,
            s.nama as supplier_nama,
            COUNT(DISTINCT ma.id) as total_agenda
        FROM meeting m
        LEFT JOIN customer c ON m.customer_id = c.id
        LEFT JOIN supplier s ON m.supplier_id = s.id
        LEFT JOIN meeting_agenda ma ON m.id = ma.meeting_id
        $where_clause
        GROUP BY m.id, m.kode_meeting, m.tanggal, m.waktu_mulai, m.waktu_selesai, m.tempat, m.jenis_meeting, m.created_at, c.nama, s.nama
        ORDER BY m.tanggal DESC, m.waktu_mulai DESC
        LIMIT $limit OFFSET $offset
    ";

    $result = mysqli_query($conn, $sql);
    if ($result) {
        while ($row = mysqli_fetch_assoc($result)) {
            $meetings[] = $row;
        }
    }

} catch (Exception $e) {
    $error_message = "Database error: " . $e->getMessage();
    error_log($error_message);
}

// Handle mysqli errors
if (mysqli_error($conn)) {
    $error_message = "MySQL Error: " . mysqli_error($conn);
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Meeting</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/font-awesome.min.css">
    <style>
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .meeting-card {
            transition: transform 0.2s;
            border-left: 4px solid #dee2e6;
        }
        .meeting-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .meeting-card.internal { border-left-color: #0d6efd; }
        .meeting-card.external { border-left-color: #fd7e14; }
        .meeting-card.customer { border-left-color: #198754; }
        .meeting-card.supplier { border-left-color: #dc3545; }
        .meeting-card.planning { border-left-color: #6f42c1; }
        .meeting-card.review { border-left-color: #20c997; }
        
        .filter-section {
            background-color: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }
        
        .meeting-date {
            font-weight: bold;
            color: #495057;
        }
        
        .meeting-time {
            color: #6c757d;
            font-size: 0.9em;
        }

        /* Button styling */
        .btn-sm {
            padding: 0.25rem 0.5rem;
            font-size: 0.875rem;
            border-radius: 0.25rem;
        }
        
        .d-flex.gap-1 {
            gap: 0.25rem !important;
        }
        .table th {
            background-color: #f8f9fa;
            border-top: none;
            font-weight: 600;
            color: #495057;
        }
        
        .table td {
            vertical-align: middle;
        }
        
        .table-hover tbody tr:hover {
            background-color: rgba(0,123,255,.075);
        }

        /* Print styles */
        @media print {
            .no-print {
                display: none !important;
            }
            .print-header {
                text-align: center;
                border-bottom: 2px solid #000;
                padding-bottom: 10px;
                margin-bottom: 20px;
            }
            body {
                font-size: 12pt;
                line-height: 1.4;
            }
            .table {
                font-size: 11pt;
            }
            .table th, .table td {
                padding: 8px 4px;
            }
        }
    </style>
</head>
<body>

<?php if (file_exists('navbar.php')) include 'navbar.php'; ?>

<div class="container mt-4">
    <div class="row">
        <div class="col-12">
            
            <?php if (isset($_SESSION['success_message'])): ?>
                <div class="alert alert-success alert-dismissible fade show">
                    <?php echo $_SESSION['success_message']; unset($_SESSION['success_message']); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if (isset($_SESSION['error_message'])): ?>
                <div class="alert alert-danger alert-dismissible fade show">
                    <?php echo $_SESSION['error_message']; unset($_SESSION['error_message']); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            
            <?php if (isset($error_message)): ?>
                <div class="alert alert-danger">
                    <h5>Database Error</h5>
                    <p><?php echo htmlspecialchars($error_message); ?></p>
                    <small>Periksa konfigurasi database atau hubungi administrator.</small>
                </div>
            <?php endif; ?>
            
            <div class="card shadow">
                <div class="card-header d-flex justify-content-between align-items-center no-print">
                    <h4 class="mb-0">
                        <i class="fa fa-list"></i> Daftar Meeting
                    </h4>
                    <div>
                        <button onclick="window.print()" class="btn btn-success me-2">
                            <i class="fa fa-print"></i> Cetak Semua
                        </button>
                        <a href="meeting_add.php" class="btn btn-light">
                            <i class="fa fa-plus"></i> Tambah Meeting
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    
                    <!-- Print Header (Only visible when printing) -->
                    <div class="print-header d-none d-print-block">
                        <h2>DAFTAR MEETING</h2>
                        <p>Tanggal Cetak: <?php echo date('d F Y'); ?></p>
                        <p>Total Meeting: <?php echo $total_records; ?></p>
                    </div>
                    
                    <!-- Summary Info -->
                    <div class="row mb-3 no-print">
                        <div class="col-md-6">
                            <div class="card text-center border-info">
                                <div class="card-body">
                                    <h5 class="text-info"><?php echo $total_records; ?></h5>
                                    <small>Total Meeting</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card text-center border-success">
                                <div class="card-body">
                                    <h5 class="text-success"><?php echo date('d M Y'); ?></h5>
                                    <small>Hari Ini</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Filter Section -->
                    <div class="filter-section no-print">
                        <form method="GET" class="row g-3">
                            <div class="col-md-6">
                                <input type="text" name="search" class="form-control" 
                                       placeholder="Cari meeting..." value="<?php echo htmlspecialchars($search); ?>">
                            </div>
                            <div class="col-md-4">
                                <select name="jenis" class="form-select">
                                    <option value="">Semua Jenis</option>
                                    <option value="internal" <?php echo $jenis_filter == 'internal' ? 'selected' : ''; ?>>Internal</option>
                                    <option value="external" <?php echo $jenis_filter == 'external' ? 'selected' : ''; ?>>External</option>
                                    <option value="customer" <?php echo $jenis_filter == 'customer' ? 'selected' : ''; ?>>Customer</option>
                                    <option value="supplier" <?php echo $jenis_filter == 'supplier' ? 'selected' : ''; ?>>Supplier</option>
                                    <option value="planning" <?php echo $jenis_filter == 'planning' ? 'selected' : ''; ?>>Planning</option>
                                    <option value="review" <?php echo $jenis_filter == 'review' ? 'selected' : ''; ?>>Review</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fa fa-search"></i> Filter
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Meeting List -->
                    <?php if (empty($meetings) && !isset($error_message)): ?>
                        <div class="text-center py-5 no-print">
                            <i class="fa fa-calendar-times fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">Tidak ada meeting ditemukan</h5>
                            <a href="meeting_add.php" class="btn btn-primary mt-2">
                                <i class="fa fa-plus"></i> Tambah Meeting Pertama
                            </a>
                        </div>
                    <?php elseif (!isset($error_message)): ?>
                        
                        <!-- Simple List View -->
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>Kode Meeting</th>
                                        <th>Tanggal & Waktu</th>
                                        <th>Tempat</th>
                                        <th>Jenis</th>
                                        <th>Peserta</th>
                                        <th>Agenda</th>
                                        <th class="no-print">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($meetings as $meeting): ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo htmlspecialchars($meeting['kode_meeting']); ?></strong>
                                            </td>
                                            <td>
                                                <div class="meeting-date">
                                                    <i class="fa fa-calendar text-primary"></i>
                                                    <?php echo date('d M Y', strtotime($meeting['tanggal'])); ?>
                                                </div>
                                                <?php if ($meeting['waktu_mulai']): ?>
                                                    <small class="text-muted">
                                                        <?php echo date('H:i', strtotime($meeting['waktu_mulai'])); ?>
                                                        <?php if ($meeting['waktu_selesai']): ?>
                                                            - <?php echo date('H:i', strtotime($meeting['waktu_selesai'])); ?>
                                                        <?php endif; ?>
                                                    </small>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <i class="fa fa-map-marker-alt text-danger"></i>
                                                <?php echo htmlspecialchars($meeting['tempat']); ?>
                                            </td>
                                            <td>
                                                <span class="badge 
                                                    <?php 
                                                    echo $meeting['jenis_meeting'] == 'internal' ? 'bg-primary' : 
                                                        ($meeting['jenis_meeting'] == 'external' ? 'bg-warning' : 
                                                        ($meeting['jenis_meeting'] == 'customer' ? 'bg-success' : 
                                                        ($meeting['jenis_meeting'] == 'supplier' ? 'bg-danger' : 
                                                        ($meeting['jenis_meeting'] == 'planning' ? 'bg-info' : 'bg-secondary')))); 
                                                    ?>">
                                                    <?php echo ucfirst(htmlspecialchars($meeting['jenis_meeting'])); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <?php if ($meeting['customer_nama'] || $meeting['supplier_nama']): ?>
                                                    <?php if ($meeting['customer_nama']): ?>
                                                        <small class="d-block">
                                                            <i class="fa fa-user text-info"></i> 
                                                            <?php echo htmlspecialchars($meeting['customer_nama']); ?>
                                                        </small>
                                                    <?php endif; ?>
                                                    <?php if ($meeting['supplier_nama']): ?>
                                                        <small class="d-block">
                                                            <i class="fa fa-truck text-secondary"></i> 
                                                            <?php echo htmlspecialchars($meeting['supplier_nama']); ?>
                                                        </small>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <small class="text-muted">-</small>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center">
                                                <span class="badge bg-light text-dark">
                                                    <?php echo (int)$meeting['total_agenda']; ?> items
                                                </span>
                                            </td>
                                            <td class="no-print">
                                                <div class="d-flex gap-1">
                                                    <button onclick="printMeeting(<?php echo (int)$meeting['id']; ?>)" 
                                                            class="btn btn-success btn-sm">
                                                        Cetak
                                                    </button>
                                                    <a href="meeting_edit.php?id=<?php echo (int)$meeting['id']; ?>" 
                                                       class="btn btn-warning btn-sm">
                                                        Edit
                                                    </a>
                                                    <button onclick="deleteMeeting(<?php echo (int)$meeting['id']; ?>, '<?php echo htmlspecialchars($meeting['kode_meeting'], ENT_QUOTES); ?>')" 
                                                            class="btn btn-danger btn-sm">
                                                        Hapus
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <?php if ($total_pages > 1): ?>
                            <nav aria-label="Meeting pagination" class="no-print">
                                <ul class="pagination justify-content-center">
                                    <li class="page-item <?php echo $page <= 1 ? 'disabled' : ''; ?>">
                                        <a class="page-link" href="?page=<?php echo $page - 1; ?>&search=<?php echo urlencode($search); ?>&jenis=<?php echo urlencode($jenis_filter); ?>">Previous</a>
                                    </li>
                                    
                                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                        <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                                            <a class="page-link" href="?page=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>&jenis=<?php echo urlencode($jenis_filter); ?>"><?php echo $i; ?></a>
                                        </li>
                                    <?php endfor; ?>
                                    
                                    <li class="page-item <?php echo $page >= $total_pages ? 'disabled' : ''; ?>">
                                        <a class="page-link" href="?page=<?php echo $page + 1; ?>&search=<?php echo urlencode($search); ?>&jenis=<?php echo urlencode($jenis_filter); ?>">Next</a>
                                    </li>
                                </ul>
                            </nav>
                        <?php endif; ?>
                        
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Konfirmasi Hapus Meeting</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus meeting <strong id="meetingName"></strong>?</p>
                <div class="alert alert-warning">
                    <i class="fa fa-exclamation-triangle"></i> 
                    <strong>Peringatan:</strong> Semua data terkait meeting ini (agenda, peserta, catatan) akan dihapus secara permanen dan tidak dapat dikembalikan.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <a href="#" id="deleteConfirmBtn" class="btn btn-danger">
                    <i class="fa fa-trash"></i> Ya, Hapus Meeting
                </a>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
function deleteMeeting(id, kodeMeeting) {
    document.getElementById('meetingName').textContent = kodeMeeting;
    document.getElementById('deleteConfirmBtn').href = '?action=delete&id=' + id;
    
    var deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
    deleteModal.show();
}

function printMeeting(id) {
    // Open meeting detail in new window for printing
    window.open('meeting_print.php?id=' + id, '_blank', 'width=800,height=600,scrollbars=yes,resizable=yes');
}

// Add print-specific styling when printing
window.addEventListener('beforeprint', function() {
    // Add any additional print preparation here
    document.body.classList.add('printing');
});

window.addEventListener('afterprint', function() {
    document.body.classList.remove('printing');
});
</script>

</body>
</html>