<?php
// Menyembunyikan semua error dan notice
error_reporting(0);

// Pastikan file config.php memiliki pengaturan koneksi database yang benar
include 'config.php';

// Fungsi untuk menerjemahkan nama hari dari Bahasa Indonesia ke Bahasa Inggris
function translateDayToEnglish($indonesianDay) {
    $days = [
        "Senin" => "Monday",
        "Selasa" => "Tuesday",
        "Rabu" => "Wednesday",
        "Kamis" => "Thursday",
        "Jumat" => "Friday",
        "Sabtu" => "Saturday",
        "Minggu" => "Sunday"
    ];
    
    return $days[$indonesianDay] ?? $indonesianDay;  // Kembalikan nama hari jika ditemukan, atau tetap dengan input
}

// Fungsi untuk menerjemahkan nama bulan dari Bahasa Indonesia ke Bahasa Inggris
function translateMonthToEnglish($indonesianMonth) {
    $months = [
        "Januari" => "January",
        "Februari" => "February",
        "Maret" => "March",
        "April" => "April",
        "Mei" => "May",
        "Juni" => "June",
        "Juli" => "July",
        "Agustus" => "August",
        "September" => "September",
        "Oktober" => "October",
        "November" => "November",
        "Desember" => "December"
    ];
    
    return $months[$indonesianMonth] ?? $indonesianMonth;  // Kembalikan nama bulan jika ditemukan, atau tetap dengan input
}

// Mengecek apakah form telah disubmit
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Mengambil data dari form textarea
    $teks = $_POST['teks'];

    // Regex untuk mengekstrak informasi sesuai dengan kriteria
    preg_match('/Tujuan\s*:\s*([A-Za-z0-9\s]+)/', $teks, $tujuan_match);  // Regex untuk Tujuan
    preg_match('/🛳\s*([^\n]*)/', $teks, $kapal_match);  // Regex yang diperbaiki untuk Kapal (mencakup lebih banyak karakter)
    preg_match('/⛔\s*CLOSING:\s*([A-Za-z0-9, ]+)/', $teks, $closing_match); // Tanggal Closing
    preg_match('/🟢\s*Est\s*Berangkat:\s*([A-Za-z0-9, ]+)/', $teks, $berangkat_match); // Tanggal Berangkat
    preg_match('/🚦\s*Est\s*Tiba:\s*([A-Za-z0-9, ]+)/', $teks, $tiba_match); // Tanggal Tiba

    // Mengekstrak hasil regex
    $tujuan = $tujuan_match[1] ?? '';  // Pastikan Tujuan diambil dengan benar
    $kapal = $kapal_match[1] ?? '';    // Memastikan kapal diambil dengan lengkap
    $closing = $closing_match[1] ?? '';
    $berangkat = $berangkat_match[1] ?? '';
    $tiba = $tiba_match[1] ?? '';

    // Menyimpan hasil terjemahan hari dan bulan ke variabel terpisah
    $translatedClosing = $closing;
    $translatedBerangkat = $berangkat;
    $translatedTiba = $tiba;

    // Menerjemahkan hari dari bahasa Indonesia ke bahasa Inggris
    $translatedClosing = preg_replace_callback('/(Senin|Selasa|Rabu|Kamis|Jumat|Sabtu|Minggu)/', function($matches) {
        return translateDayToEnglish($matches[0]);
    }, $translatedClosing);

    $translatedBerangkat = preg_replace_callback('/(Senin|Selasa|Rabu|Kamis|Jumat|Sabtu|Minggu)/', function($matches) {
        return translateDayToEnglish($matches[0]);
    }, $translatedBerangkat);

    $translatedTiba = preg_replace_callback('/(Senin|Selasa|Rabu|Kamis|Jumat|Sabtu|Minggu)/', function($matches) {
        return translateDayToEnglish($matches[0]);
    }, $translatedTiba);

    // Menerjemahkan bulan dari bahasa Indonesia ke bahasa Inggris
    $translatedClosing = preg_replace_callback('/(Januari|Februari|Maret|April|Mei|Juni|Juli|Agustus|September|Oktober|November|Desember)/', function($matches) {
        return translateMonthToEnglish($matches[0]);
    }, $translatedClosing);

    $translatedBerangkat = preg_replace_callback('/(Januari|Februari|Maret|April|Mei|Juni|Juli|Agustus|September|Oktober|November|Desember)/', function($matches) {
        return translateMonthToEnglish($matches[0]);
    }, $translatedBerangkat);

    $translatedTiba = preg_replace_callback('/(Januari|Februari|Maret|April|Mei|Juni|Juli|Agustus|September|Oktober|November|Desember)/', function($matches) {
        return translateMonthToEnglish($matches[0]);
    }, $translatedTiba);

    // Mengonversi tanggal (format dd, MMMM, yyyy)
    $closing_date = DateTime::createFromFormat('l, d F', $translatedClosing);
    $berangkat_date = DateTime::createFromFormat('l, d F', $translatedBerangkat);
    $tiba_date = DateTime::createFromFormat('l, d F', $translatedTiba);

    // Menampilkan hasil konversi tanggal dalam format debug
    echo "<h3>Debugging Output:</h3>";
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>Tujuan</th><td>" . htmlspecialchars($tujuan) . "</td></tr>";
    echo "<tr><th>Kapal</th><td>" . htmlspecialchars($kapal) . "</td></tr>";
    echo "<tr><th>Closing</th><td>" . htmlspecialchars($closing) . "</td></tr>";
    echo "<tr><th>Berangkat</th><td>" . htmlspecialchars($berangkat) . "</td></tr>";
    echo "<tr><th>Tiba</th><td>" . htmlspecialchars($tiba) . "</td></tr>";
    echo "<tr><th>Closing Date</th><td>" . ($closing_date ? $closing_date->format('Y-m-d') : 'Format salah') . "</td></tr>";
    echo "<tr><th>Berangkat Date</th><td>" . ($berangkat_date ? $berangkat_date->format('Y-m-d') : 'Format salah') . "</td></tr>";
    echo "<tr><th>Tiba Date</th><td>" . ($tiba_date ? $tiba_date->format('Y-m-d') : 'Format salah') . "</td></tr>";
    echo "</table><br>";

    // Memeriksa apakah data berhasil diekstrak dan format tanggal berhasil
    if ($tujuan && $kapal && $closing_date && $berangkat_date && $tiba_date) {
        // Menyimpan data ke database
        $stmt = $conn->prepare("INSERT INTO shipment_info (tujuan, kapal, closing, berangkat, tiba) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sssss", $tujuan, $kapal, $closing_date->format('Y-m-d'), $berangkat_date->format('Y-m-d'), $tiba_date->format('Y-m-d'));

        // Menjalankan query
        if ($stmt->execute()) {
            echo "Data berhasil disimpan!";
        } else {
            echo "Terjadi kesalahan saat menyimpan data: " . $stmt->error;
        }

        // Menutup statement
        $stmt->close();
    } else {
        echo "Data tidak lengkap atau format salah!";
    }
}

// Menutup koneksi
$conn->close();
?>

<!-- Tombol Kembali ke Form Input -->
<form action="input_kapal.php" method="get">
    <button type="submit">Kembali ke Form Input</button>
</form>

<!-- Styling untuk Debugging Output -->
<style>
    h3 {
        font-size: 1.5rem;
        color: #333;
    }

    table {
        width: 100%;
        margin-top: 20px;
        border-collapse: collapse;
    }

    th, td {
        padding: 8px 12px;
        text-align: left;
        border: 1px solid #ddd;
    }

    th {
        background-color: #f4f4f4;
        font-weight: bold;
    }

    button[type="submit"] {
        margin-top: 20px;
        padding: 12px 15px;
        background-color: #007bff;
        color: white;
        font-size: 1rem;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    button[type="submit"]:hover {
        background-color: #0056b3;
    }
</style>
