<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'config.php';

header('Content-Type: text/plain');

try {
    // Get kota parameter
    $kota = isset($_GET['kota']) ? trim($_GET['kota']) : '';
    
    if (empty($kota) || strlen($kota) < 3) {
        echo '';
        exit;
    }
    
    // Generate kode prefix from first 3 characters of kota
    $kode_prefix = strtoupper(substr($kota, 0, 3));
    
    // Get the highest existing number for this prefix
    $query = "SELECT MAX(CAST(SUBSTRING(kode, 4) AS UNSIGNED)) as max_num 
              FROM customer 
              WHERE kode LIKE ?";
    
    $stmt = mysqli_prepare($conn, $query);
    if (!$stmt) {
        throw new Exception("Prepare statement failed: " . mysqli_error($conn));
    }
    
    $like_pattern = $kode_prefix . '%';
    mysqli_stmt_bind_param($stmt, "s", $like_pattern);
    
    if (!mysqli_stmt_execute($stmt)) {
        throw new Exception("Execute failed: " . mysqli_stmt_error($stmt));
    }
    
    $result = mysqli_stmt_get_result($stmt);
    $row = mysqli_fetch_assoc($result);
    
    // Generate next number
    $next_num = ($row['max_num'] ?? 0) + 1;
    $kode = $kode_prefix . str_pad($next_num, 3, '0', STR_PAD_LEFT);
    
    mysqli_stmt_close($stmt);
    
    echo $kode;

} catch (Exception $e) {
    // Return empty string on error to not break the form
    echo '';
}
?>