<?php
session_start();
include 'config.php';

echo "<h2>DEBUG PIUTANG - CEK DATA</h2>";

// 1. Cek semua penjualan belum bayar
echo "<h3>1. Semua Penjualan Belum Bayar:</h3>";
$query1 = "SELECT p.id, p.no_invoice, p.tanggal, p.grand_total, p.rekening, r.nama_rekening, c.nama 
           FROM penjualan p 
           LEFT JOIN rekening r ON p.rekening_id = r.id
           LEFT JOIN customer c ON p.customer_id = c.id
           WHERE p.status_bayar = 'belum_bayar'
           ORDER BY p.tanggal DESC";

$result1 = mysqli_query($conn, $query1);
echo "<table border='1'>";
echo "<tr><th>ID</th><th>Invoice</th><th>Tanggal</th><th>Grand Total</th><th>Rekening Field</th><th>Rekening Table</th><th>Customer</th></tr>";
while($row = mysqli_fetch_assoc($result1)) {
    echo "<tr>";
    echo "<td>" . $row['id'] . "</td>";
    echo "<td>" . $row['no_invoice'] . "</td>";
    echo "<td>" . $row['tanggal'] . "</td>";
    echo "<td>" . number_format($row['grand_total']) . "</td>";
    echo "<td>" . $row['rekening'] . "</td>";
    echo "<td>" . $row['nama_rekening'] . "</td>";
    echo "<td>" . $row['nama'] . "</td>";
    echo "</tr>";
}
echo "</table>";

// 2. Cek detail penjualan untuk invoice yang grand_total = 0
echo "<h3>2. Detail Penjualan untuk Invoice yang Grand Total = 0:</h3>";
$query2 = "SELECT p.id, p.no_invoice, pd.produk_id, pd.qty, pd.harga, pd.total, pi.nama
           FROM penjualan p
           LEFT JOIN penjualan_detail pd ON p.id = pd.penjualan_id
           LEFT JOIN produk_interest pi ON pd.produk_id = pi.id
           WHERE p.status_bayar = 'belum_bayar' AND p.grand_total = 0
           ORDER BY p.id, pd.id";

$result2 = mysqli_query($conn, $query2);
echo "<table border='1'>";
echo "<tr><th>Penjualan ID</th><th>Invoice</th><th>Produk</th><th>Qty</th><th>Harga</th><th>Total</th></tr>";
while($row = mysqli_fetch_assoc($result2)) {
    echo "<tr>";
    echo "<td>" . $row['id'] . "</td>";
    echo "<td>" . $row['no_invoice'] . "</td>";
    echo "<td>" . $row['nama'] . "</td>";
    echo "<td>" . $row['qty'] . "</td>";
    echo "<td>" . number_format($row['harga']) . "</td>";
    echo "<td>" . number_format($row['total']) . "</td>";
    echo "</tr>";
}
echo "</table>";

// 3. Hitung manual total per invoice
echo "<h3>3. Perhitungan Manual Total per Invoice:</h3>";
$query3 = "SELECT p.id, p.no_invoice, p.grand_total,
           SUM(pd.qty * pd.harga) as calculated_total,
           SUM(pd.total) as sum_total_field
           FROM penjualan p
           LEFT JOIN penjualan_detail pd ON p.id = pd.penjualan_id
           WHERE p.status_bayar = 'belum_bayar'
           GROUP BY p.id, p.no_invoice, p.grand_total";

$result3 = mysqli_query($conn, $query3);
echo "<table border='1'>";
echo "<tr><th>ID</th><th>Invoice</th><th>Grand Total DB</th><th>Calculated (qty*harga)</th><th>Sum Total Field</th></tr>";
while($row = mysqli_fetch_assoc($result3)) {
    echo "<tr>";
    echo "<td>" . $row['id'] . "</td>";
    echo "<td>" . $row['no_invoice'] . "</td>";
    echo "<td style='color: red;'>" . number_format($row['grand_total']) . "</td>";
    echo "<td style='color: blue;'>" . number_format($row['calculated_total']) . "</td>";
    echo "<td style='color: green;'>" . number_format($row['sum_total_field']) . "</td>";
    echo "</tr>";
}
echo "</table>";

// 4. Cek trigger atau update manual
echo "<h3>4. Update Manual Grand Total (JALANKAN INI!):</h3>";
$update_query = "UPDATE penjualan p 
                 SET grand_total = (
                     SELECT COALESCE(SUM(pd.qty * pd.harga), 0) 
                     FROM penjualan_detail pd 
                     WHERE pd.penjualan_id = p.id
                 ) 
                 WHERE p.grand_total = 0 AND p.status_bayar = 'belum_bayar'";

if(isset($_GET['update'])) {
    if(mysqli_query($conn, $update_query)) {
        echo "<p style='color: green;'>SUCCESS: Grand total berhasil diupdate!</p>";
        echo "<a href='debug_piutang.php'>Refresh untuk lihat hasil</a>";
    } else {
        echo "<p style='color: red;'>ERROR: " . mysqli_error($conn) . "</p>";
    }
} else {
    echo "<a href='debug_piutang.php?update=1' style='background: red; color: white; padding: 10px; text-decoration: none;'>KLIK DISINI UNTUK UPDATE GRAND TOTAL</a>";
}

// 5. Cek rekening
echo "<h3>5. Daftar Rekening:</h3>";
$query5 = "SELECT * FROM rekening";
$result5 = mysqli_query($conn, $query5);
echo "<table border='1'>";
echo "<tr><th>ID</th><th>Nama Rekening</th><th>Bank</th><th>Aktif</th></tr>";
while($row = mysqli_fetch_assoc($result5)) {
    echo "<tr>";
    echo "<td>" . $row['id'] . "</td>";
    echo "<td>" . $row['nama_rekening'] . "</td>";
    echo "<td>" . $row['nama_bank'] . "</td>";
    echo "<td>" . $row['aktif'] . "</td>";
    echo "</tr>";
}
echo "</table>";

?>

<style>
table { border-collapse: collapse; width: 100%; margin: 10px 0; }
th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
th { background-color: #f2f2f2; }
h3 { color: #333; margin-top: 30px; }
</style>