<?php
include 'config.php';

// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h2>Debug Pembelian System</h2>";

// 1. Test database connection
echo "<h3>1. Database Connection Test</h3>";
if ($conn) {
    echo "✅ Database connected successfully<br>";
} else {
    echo "❌ Database connection failed: " . mysqli_connect_error() . "<br>";
    exit;
}

// 2. Check if tables exist
echo "<h3>2. Tables Check</h3>";
$tables_to_check = ['pembelian', 'pembelian_detail', 'penjualan_pembelian_link'];

foreach ($tables_to_check as $table) {
    $result = mysqli_query($conn, "SHOW TABLES LIKE '$table'");
    if (mysqli_num_rows($result) > 0) {
        echo "✅ Table '$table' exists<br>";
    } else {
        echo "❌ Table '$table' does not exist<br>";
    }
}

// 3. Test basic insert
echo "<h3>3. Basic Insert Test</h3>";
try {
    // Test insert pembelian
    $test_query = "INSERT INTO pembelian (no_pembelian, tanggal, supplier_id, total_amount, keterangan, status) 
                   VALUES ('TEST001', '2025-09-22', 1, 100000, 'Test insert', 'draft')";
    
    if (mysqli_query($conn, $test_query)) {
        $test_id = mysqli_insert_id($conn);
        echo "✅ Test insert berhasil, ID: $test_id<br>";
        
        // Clean up test data
        mysqli_query($conn, "DELETE FROM pembelian WHERE id = $test_id");
        echo "✅ Test data cleaned up<br>";
    } else {
        echo "❌ Test insert gagal: " . mysqli_error($conn) . "<br>";
    }
} catch (Exception $e) {
    echo "❌ Exception during insert test: " . $e->getMessage() . "<br>";
}

// 4. Check POST data if this is called from form
echo "<h3>4. POST Data Check</h3>";
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    echo "<strong>POST Data received:</strong><br>";
    echo "<pre>";
    print_r($_POST);
    echo "</pre>";
    
    echo "<strong>FILES Data:</strong><br>";
    echo "<pre>";
    print_r($_FILES);
    echo "</pre>";
} else {
    echo "No POST data (normal - this is GET request)<br>";
}

// 5. Test file upload directory
echo "<h3>5. File Upload Directory Check</h3>";
$upload_dir = 'nota_pembelian/';
if (!is_dir($upload_dir)) {
    if (mkdir($upload_dir, 0755, true)) {
        echo "✅ Directory '$upload_dir' created successfully<br>";
    } else {
        echo "❌ Failed to create directory '$upload_dir'<br>";
    }
} else {
    echo "✅ Directory '$upload_dir' already exists<br>";
}

// Check if directory is writable
if (is_writable($upload_dir)) {
    echo "✅ Directory '$upload_dir' is writable<br>";
} else {
    echo "❌ Directory '$upload_dir' is not writable<br>";
}

// 6. PHP Configuration Check
echo "<h3>6. PHP Configuration</h3>";
echo "PHP Version: " . phpversion() . "<br>";
echo "Upload Max Filesize: " . ini_get('upload_max_filesize') . "<br>";
echo "Post Max Size: " . ini_get('post_max_size') . "<br>";
echo "Max Execution Time: " . ini_get('max_execution_time') . " seconds<br>";

?>

<hr>
<h3>Manual Test Form</h3>
<form action="debug_pembelian.php" method="POST" enctype="multipart/form-data">
    <p>No Pembelian: <input type="text" name="no_pembelian" value="TEST<?php echo date('YmdHis'); ?>" required></p>
    <p>Tanggal: <input type="date" name="tanggal" value="<?php echo date('Y-m-d'); ?>" required></p>
    <p>Supplier ID: <input type="number" name="supplier_id" value="1" required></p>
    <p>Keterangan: <input type="text" name="keterangan" value="Test manual"></p>
    
    <p>Produk ID: <input type="number" name="produk_id[]" value="1" required></p>
    <p>Qty Beli: <input type="number" name="qty_beli[]" value="10" step="0.01" required></p>
    <p>Satuan: <input type="text" name="satuan[]" value="PCS" required></p>
    <p>Harga Beli: <input type="number" name="harga_beli[]" value="5000" required></p>
    
    <p>Test File: <input type="file" name="nota_file[]" accept=".pdf,.jpg,.jpeg,.png"></p>
    
    <p><button type="submit">Test Submit</button></p>
</form>